/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.animations;

import com.mlib.animations.Frame;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.phys.Vec3;

public class Animation<Type> {
    protected static final float FRAME_STEP = 0.6666667f;
    protected final List<Frame<Type>> frames = new ArrayList<Frame<Type>>();
    protected float lastDuration = 0.0f;
    protected float delta = 0.0f;
    protected int extraTicks = 0;

    public static void applyRotationInDegrees(Vec3 value, ModelPart modelPart) {
        modelPart.m_171327_((float)(0.01745329238474369 * value.f_82479_), (float)(0.01745329238474369 * value.f_82480_), (float)(0.01745329238474369 * value.f_82481_));
    }

    public static void applyPosition(Vec3 value, ModelPart modelPart) {
        modelPart.m_104227_((float)value.f_82479_, (float)value.f_82480_, (float)value.f_82481_);
    }

    public Animation<Type> addFrame(Frame<Type> frame) {
        this.frames.add(frame);
        return this;
    }

    public Type apply(float duration) {
        if (duration != this.lastDuration) {
            this.delta = duration > this.lastDuration ? duration - this.lastDuration : 0.0f;
            this.lastDuration = duration;
            this.extraTicks = 0;
        } else {
            ++this.extraTicks;
        }
        float newDuration = duration + this.delta * (1.0f - (float)Math.pow(0.6666666865348816, this.extraTicks));
        Frame<Type> currentFrame = null;
        Frame<Type> nextFrame = null;
        for (int i = 0; i < this.frames.size(); ++i) {
            Frame<Type> frame = this.frames.get(i);
            if (newDuration > frame.startDuration) {
                if (i != this.frames.size() - 1) continue;
                return frame.getValue();
            }
            if (i == 0) {
                return frame.getValue();
            }
            currentFrame = this.frames.get(Math.max(i - 1, 0));
            nextFrame = this.frames.get(i);
            break;
        }
        if (currentFrame == null || nextFrame == null) {
            throw new InvalidParameterException("Animation does not have valid frames");
        }
        return this.interpolate(newDuration, currentFrame, nextFrame);
    }

    protected Type interpolate(float duration, Frame<Type> currentFrame, Frame<Type> nextFrame) {
        float ratio = (duration - currentFrame.startDuration) / (nextFrame.startDuration - currentFrame.startDuration);
        ratio = nextFrame.interpolationType.apply(ratio);
        return currentFrame.interpolate(ratio, nextFrame);
    }
}

