/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.animations;

import net.minecraft.util.Mth;

public abstract class Frame<Type> {
    public final float startDuration;
    public final Type value;
    public final InterpolationType interpolationType;

    public Frame(float startDuration, Type value, InterpolationType interpolationType) {
        this.startDuration = startDuration;
        this.value = value;
        this.interpolationType = interpolationType;
    }

    public Frame(float startDuration, Type value) {
        this(startDuration, value, InterpolationType.LINEAR);
    }

    public abstract Type interpolate(float var1, Frame<Type> var2);

    public Type getValue() {
        return this.value;
    }

    public static enum InterpolationType {
        LINEAR(x -> x),
        SQUARE(x -> x * x),
        SQUARE_ROOT(Mth::m_14116_),
        CUBE(x -> x * x * x);

        private final IFormula formula;

        private InterpolationType(IFormula formula) {
            this.formula = formula;
        }

        public float apply(float ratio) {
            return this.formula.apply(ratio);
        }

        protected static interface IFormula {
            public float apply(float var1);
        }
    }
}

