/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.items;

import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;

public class SpawnEggFactory {
    private static final SpawnEggBehavior SPAWN_EGG_BEHAVIOR = new SpawnEggBehavior();
    private static CreativeModeTab ITEM_GROUP = CreativeModeTab.f_40753_;

    public static void addDispenseBehaviorTo(SpawnEggItem spawnEgg) {
        DispenserBlock.m_52672_((ItemLike)spawnEgg, (DispenseItemBehavior)SPAWN_EGG_BEHAVIOR);
    }

    public static SpawnEggItem createSpawnEgg(EntityType<? extends Mob> entityType, int primaryColor, int secondaryColor) {
        Item.Properties itemProperties = new Item.Properties().m_41491_(ITEM_GROUP);
        SpawnEggItem spawnEggItem = new SpawnEggItem(entityType, primaryColor, secondaryColor, itemProperties);
        SpawnEggFactory.addDispenseBehaviorTo(spawnEggItem);
        return spawnEggItem;
    }

    public static RegistryObject<SpawnEggItem> createRegistrySpawnEgg(DeferredRegister<Item> deferredRegister, String registryName, EntityType<? extends Mob> entityType, int primaryColor, int secondaryColor) {
        return deferredRegister.register(registryName, () -> SpawnEggFactory.createSpawnEgg(entityType, primaryColor, secondaryColor));
    }

    public static RegistryObject<SpawnEggItem> createRegistrySpawnEgg(DeferredRegister<Item> deferredRegister, String registryName, SpawnEggItem spawnEgg) {
        return deferredRegister.register(registryName, () -> spawnEgg);
    }

    public static void setDefaultItemGroup(CreativeModeTab modeTab) {
        ITEM_GROUP = modeTab;
    }

    private static final class SpawnEggBehavior
    extends DefaultDispenseItemBehavior {
        private SpawnEggBehavior() {
        }

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BlockPos blockPosition = source.m_7961_();
            BlockState blockState = source.m_6414_();
            Direction direction = (Direction)blockState.m_61143_((Property)DispenserBlock.f_52659_);
            EntityType entityType = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
            entityType.m_20592_(source.m_7727_(), stack, null, blockPosition.m_141952_(direction.m_122436_()), MobSpawnType.DISPENSER, direction != Direction.UP, false);
            stack.m_41774_(1);
            return stack;
        }
    }
}

