/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.loot_modifiers;

import com.google.gson.JsonObject;
import com.mlib.LevelHelper;
import com.mlib.MajruszLibrary;
import com.mlib.Random;
import com.mlib.entities.EntityHelper;
import com.mlib.loot_modifiers.LootHelper;
import com.mlib.particles.ParticleHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;

public class SmeltingItems
extends LootModifier {
    public static final List<Register> registerList = new ArrayList<Register>();

    protected SmeltingItems(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ItemStack tool = (ItemStack)LootHelper.getParameter(context, LootContextParams.f_81463_);
        Player player = EntityHelper.getPlayerFromEntity((Entity)LootHelper.getParameter(context, LootContextParams.f_81455_));
        BlockState blockState = (BlockState)LootHelper.getParameter(context, LootContextParams.f_81461_);
        ServerLevel level = LevelHelper.getServerLevelFromEntity((Entity)player);
        if (blockState == null || level == null || player.m_6047_() || !SmeltingItems.shouldBeExecuted(level, player, tool, blockState)) {
            return generatedLoot;
        }
        return this.getSmeltedLoot(generatedLoot, context.m_78952_(), (Vec3)LootHelper.getParameter(context, LootContextParams.f_81460_));
    }

    protected static boolean shouldBeExecuted(ServerLevel level, Player player, @Nullable ItemStack tool, BlockState blockState) {
        for (Register register : registerList) {
            if (!register.shouldBeExecuted(level, player, tool, blockState)) continue;
            return true;
        }
        return false;
    }

    protected ItemStack smeltIfPossible(ItemStack itemStack, ServerLevel level) {
        return level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{itemStack}), (Level)level).map(AbstractCookingRecipe::m_8043_).filter(i -> !i.m_41619_()).map(i -> ItemHandlerHelper.copyStackWithSize((ItemStack)i, (int)(itemStack.m_41613_() * i.m_41613_()))).orElse(itemStack);
    }

    protected int calculateRandomExperienceForRecipe(SmeltingRecipe recipe, int smeltedItems) {
        return Random.randomizeExperience(recipe.m_43750_() * (float)smeltedItems);
    }

    protected ItemStack getSmeltedItemStack(ItemStack itemStackToSmelt, ServerLevel level) {
        ItemStack smeltedItemStack = this.smeltIfPossible(itemStackToSmelt, level);
        if (smeltedItemStack.m_41613_() != itemStackToSmelt.m_41613_()) {
            smeltedItemStack.m_41764_(itemStackToSmelt.m_41613_());
        }
        return smeltedItemStack;
    }

    protected List<ItemStack> getSmeltedLoot(List<ItemStack> generatedLoot, ServerLevel level, Vec3 position) {
        RecipeManager recipeManager = level.m_7465_();
        int amountOfSmeltedItems = 0;
        ArrayList<ItemStack> smeltedLoot = new ArrayList<ItemStack>();
        for (ItemStack itemStack : generatedLoot) {
            smeltedLoot.add(this.getSmeltedItemStack(itemStack, level));
            Optional recipe = recipeManager.m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{itemStack}), (Level)level);
            if (recipe.isEmpty()) continue;
            int experience = this.calculateRandomExperienceForRecipe((SmeltingRecipe)recipe.get(), itemStack.m_41613_());
            if (experience > 0) {
                level.m_7967_((Entity)new ExperienceOrb((Level)level, position.f_82479_, position.f_82480_, position.f_82481_, experience));
            }
            amountOfSmeltedItems += itemStack.m_41613_();
        }
        if (amountOfSmeltedItems > 0) {
            ParticleHelper.spawnSmeltParticles(level, position, 3 + amountOfSmeltedItems + MajruszLibrary.RANDOM.nextInt(4));
        }
        return smeltedLoot;
    }

    @FunctionalInterface
    public static interface Register {
        public boolean shouldBeExecuted(ServerLevel var1, Player var2, @Nullable ItemStack var3, BlockState var4);
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<SmeltingItems> {
        public SmeltingItems read(ResourceLocation name, JsonObject object, LootItemCondition[] conditionsIn) {
            return new SmeltingItems(conditionsIn);
        }

        public JsonObject write(SmeltingItems instance) {
            return null;
        }
    }
}

