/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.nbt;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;

public class NBTHelper {
    public static void saveBlockPos(CompoundTag tag, String key, BlockPos position) {
        tag.m_128405_(key + "X", position.m_123341_());
        tag.m_128405_(key + "Y", position.m_123342_());
        tag.m_128405_(key + "Z", position.m_123343_());
    }

    public static BlockPos loadBlockPos(CompoundTag tag, String key) {
        return new BlockPos(tag.m_128451_(key + "X"), tag.m_128451_(key + "Y"), tag.m_128451_(key + "Z"));
    }

    @Deprecated
    public static void setNBTInteger(LivingEntity entity, String key, int value) {
        CompoundTag nbt = entity.getPersistentData();
        nbt.m_128405_(key, value);
    }

    @Deprecated
    public static void setNBTInteger(LivingEntity entity, String key, IValueFormula<Integer> formula) {
        CompoundTag nbt = entity.getPersistentData();
        nbt.m_128405_(key, formula.apply(nbt.m_128451_(key)).intValue());
    }

    @Deprecated
    public static int getNBTInteger(LivingEntity entity, String key) {
        CompoundTag nbt = entity.getPersistentData();
        return nbt.m_128451_(key);
    }

    @Deprecated
    @FunctionalInterface
    public static interface IValueFormula<Type> {
        public Type apply(Type var1);
    }

    public static abstract class NBTData<Type> {
        public final String key;
        public final CompoundTag nbt;

        public NBTData(LivingEntity entity, String key, Type defaultValue) {
            this.key = key;
            this.nbt = entity.getPersistentData();
            if (!this.nbt.m_128441_(this.key)) {
                this.set(defaultValue);
            }
        }

        public abstract void set(Type var1);

        public void set(IValueFormula<Type> formula) {
            this.set(formula.apply(this.get()));
        }

        public abstract Type get();

        @FunctionalInterface
        public static interface IValueFormula<Type> {
            public Type apply(Type var1);
        }
    }

    public static class FloatData
    extends NBTData<Float> {
        public FloatData(LivingEntity entity, String key) {
            super(entity, key, Float.valueOf(0.0f));
        }

        @Override
        public void set(Float value) {
            this.nbt.m_128350_(this.key, value.floatValue());
        }

        @Override
        public Float get() {
            return Float.valueOf(this.nbt.m_128457_(this.key));
        }
    }

    public static class BooleanData
    extends NBTData<Boolean> {
        public BooleanData(LivingEntity entity, String key) {
            super(entity, key, false);
        }

        @Override
        public void set(Boolean value) {
            this.nbt.m_128379_(this.key, value.booleanValue());
        }

        @Override
        public Boolean get() {
            return this.nbt.m_128471_(this.key);
        }
    }

    public static class IntegerData
    extends NBTData<Integer> {
        public IntegerData(LivingEntity entity, String key) {
            super(entity, key, 0);
        }

        @Override
        public void set(Integer value) {
            this.nbt.m_128405_(this.key, value.intValue());
        }

        @Override
        public Integer get() {
            return this.nbt.m_128451_(this.key);
        }
    }
}

