/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.time;

import com.mlib.TimeConverter;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class Delay {
    private int ticksLeft;
    private final ICallable callable;
    private static final List<Delay> DELAYS = new ArrayList<Delay>();

    public Delay(int ticks, ICallable callable) {
        this.ticksLeft = ticks;
        this.callable = callable;
        DELAYS.add(this);
    }

    public Delay(double seconds, ICallable callable) {
        this(TimeConverter.secondsToTicks(seconds), callable);
    }

    public boolean hasExpired() {
        return this.ticksLeft <= 0;
    }

    @SubscribeEvent
    public static void onServerTick() {
        for (Delay delay : DELAYS) {
            if (delay.ticksLeft > 0) {
                --delay.ticksLeft;
            }
            if (!delay.hasExpired()) continue;
            delay.callable.call();
        }
        DELAYS.removeIf(Delay::hasExpired);
    }

    public static interface ICallable {
        public void call();
    }
}

