/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render.buffer;

import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.client.render.OptimizedPictureRenderer;

public class BufferManager {
    private final OptimizedPictureRenderer[] mips;
    private final OptimizedPictureRenderer fullSize;
    private final int maxSize;
    private int[] sizes;

    public BufferManager(OptimizedPictureRenderer fullSize, int maxMips, int maxSize) {
        this.fullSize = fullSize;
        this.maxSize = maxSize;
        this.mips = new OptimizedPictureRenderer[maxMips];
        this.sizes = new int[maxMips];
    }

    public OptimizedPictureRenderer get(int resolution) {
        if (resolution >= this.maxSize) {
            return this.fullSize;
        }
        int mipMap = this.maxSize / resolution;
        if (mipMap > this.mips.length) {
            mipMap = this.mips.length;
        }
        while (mipMap > 0) {
            OptimizedPictureRenderer buffer;
            if ((buffer = this.mips[--mipMap]) == null) continue;
            return buffer;
        }
        return this.fullSize;
    }

    public void putMips(OptimizedPictureRenderer buffer, int index) {
        if (this.mips[index] != null) {
            throw new IllegalStateException("Mip at index " + index + " already present");
        }
        if (this.sizes == null) {
            throw new IllegalStateException("Already complete!");
        }
        if (buffer == null) {
            this.mips[index] = index == 0 ? this.fullSize : this.mips[index - 1];
            this.sizes[index] = this.getRects(index - 1);
        } else {
            this.mips[index] = buffer;
            this.sizes[index] = buffer.getInstructions();
        }
    }

    private int getRects(int index) {
        if (index == -1) {
            return this.fullSize.getInstructions();
        }
        int rects = this.sizes[index];
        if (rects == 0) {
            throw new RuntimeException("Index " + index + " does not have mip info");
        }
        return rects;
    }

    public void complete() {
        this.sizes = null;
        for (int i = 0; i < this.mips.length; ++i) {
            if (this.mips[i] != null) continue;
            this.mips[i] = this.fullSize;
        }
    }

    public boolean needDiscard(int rects, int mipIndex) {
        boolean result;
        boolean bl = result = rects == -1 || (Boolean)MCPaintConfig.CLIENT.enableMipMaps.get() == false || (double)((float)rects / (float)this.getRects(mipIndex - 2)) > (Double)MCPaintConfig.CLIENT.maxMipSize.get();
        if (result) {
            MCPaint.LOGGER.debug("Discarding mip level {}, with {} rects", (Object)mipIndex, (Object)rects);
        }
        return result;
    }
}

