/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common;

import com.google.common.collect.ImmutableMap;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.INameMappingService;
import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.common.block.BlockCanvas;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.item.ItemBrush;
import ichttt.mods.mcpaint.common.item.ItemStamp;
import ichttt.mods.mcpaint.common.material.MaterialDefinitions;
import ichttt.mods.mcpaint.common.material.MaterialFileGenerator;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RegistryObjects {
    private static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"mcpaint");
    private static final DeferredRegister<Block> BLOCK_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"mcpaint");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"mcpaint");
    public static final RegistryObject<Item> BRUSH = ITEM_REGISTER.register("brush", ItemBrush::new);
    public static final RegistryObject<Item> STAMP = ITEM_REGISTER.register("stamp", ItemStamp::new);
    public static final Map<Material, RegistryObject<Block>> CANVAS_BLOCKS = RegistryObjects.generateCanvasBlockEntries();
    public static final RegistryObject<BlockEntityType<TileEntityCanvas>> CANVAS_BE = BLOCK_ENTITY_TYPE_REGISTER.register("canvas_te", () -> BlockEntityType.Builder.m_155273_(TileEntityCanvas::new, (Block[])((Block[])CANVAS_BLOCKS.values().stream().map(Supplier::get).toArray(Block[]::new))).m_58966_(null));

    private static Map<Material, RegistryObject<Block>> generateCanvasBlockEntries() {
        MaterialDefinitions definitions;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!FMLLoader.isProduction()) {
            MCPaint.LOGGER.info("Not running in prod mode. Regenerating block mappings");
            MaterialDefinitions oldDefinitions = null;
            try {
                oldDefinitions = new MaterialDefinitions(RegistryObjects.class.getResourceAsStream("/mcpaint_materials.txt"));
            }
            catch (IOException | RuntimeException e) {
                MCPaint.LOGGER.warn("Old definitions not present!");
            }
            try {
                definitions = MaterialFileGenerator.generateMaterialFile(oldDefinitions);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to generate material file!", e);
            }
        }
        try {
            definitions = new MaterialDefinitions(RegistryObjects.class.getResourceAsStream("/mcpaint_materials.txt"));
        }
        catch (IOException | RuntimeException e) {
            MCPaint.LOGGER.fatal("Failed to read materials list!", (Throwable)e);
            throw new RuntimeException("Failed to read materials list!", e);
        }
        for (Map.Entry<String, String> entry : definitions.getSrg2Mcp().entrySet()) {
            String keyToUse = entry.getKey();
            if (!FMLLoader.isProduction()) {
                BiFunction mappingFunc = (BiFunction)Launcher.INSTANCE.environment().findNameMapping("srg").orElseThrow(() -> new RuntimeException("Missing srg provider"));
                keyToUse = (String)mappingFunc.apply(INameMappingService.Domain.FIELD, keyToUse);
            }
            try {
                Field declaredField = Material.class.getDeclaredField(keyToUse);
                Material material = (Material)declaredField.get(null);
                builder.put((Object)material, (Object)BLOCK_REGISTER.register("canvas_" + entry.getValue(), () -> new BlockCanvas(material)));
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                MCPaint.LOGGER.error("Failed to lookup material {} (srg:{}, regname:{})", (Object)keyToUse, (Object)entry.getKey(), (Object)entry.getValue(), (Object)e);
            }
        }
        ImmutableMap build = builder.build();
        MCPaint.LOGGER.debug("Found {} materials", (Object)build);
        return build;
    }

    public static void registerToBus(IEventBus bus) {
        ITEM_REGISTER.register(bus);
        BLOCK_REGISTER.register(bus);
        BLOCK_ENTITY_TYPE_REGISTER.register(bus);
    }
}

