/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.material;

import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.common.material.MaterialDefinitions;
import ichttt.mods.mcpaint.common.material.ReverseMappingResolver;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fml.loading.FMLLoader;

public class MaterialFileGenerator {
    public static MaterialDefinitions generateMaterialFile(MaterialDefinitions originalDefinitions) throws IOException, ReflectiveOperationException, InterruptedException {
        String mcVersion = FMLLoader.versionInfo().mcVersion();
        if (originalDefinitions != null) {
            if (mcVersion.equals(originalDefinitions.getVersion())) {
                MCPaint.LOGGER.info("Material definitions do not differ in versions! Using old definitions");
                return originalDefinitions;
            }
            MCPaint.LOGGER.info("Material definitions differ in version!");
        }
        Map<String, String> srgToOfficial = ReverseMappingResolver.loadMappingFor(Material.class, MaterialFileGenerator::getNameForRegistry);
        MaterialDefinitions newDef = new MaterialDefinitions(mcVersion, srgToOfficial);
        MaterialFileGenerator.writeDefinition(newDef);
        if (originalDefinitions != null && !newDef.getSrg2Mcp().equals(originalDefinitions.getSrg2Mcp())) {
            MCPaint.LOGGER.warn("Material definitions differ! Manually audit the changes!");
            System.exit(-999);
            throw new RuntimeException("Cant get here");
        }
        return newDef;
    }

    private static String getNameForRegistry(String name) {
        if (name.equalsIgnoreCase("stone")) {
            return "rock";
        }
        if (name.equalsIgnoreCase("dirt")) {
            return "ground";
        }
        return name.toLowerCase(Locale.ROOT);
    }

    private static void writeDefinition(MaterialDefinitions def) throws IOException {
        Path path = Paths.get("../src/main/resources/", new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            MCPaint.LOGGER.fatal("Failed to write file! Resource path does not exist!");
            System.exit(-888);
            throw new RuntimeException("Cant get here");
        }
        Path resolve = path.resolve("mcpaint_materials.txt");
        Set<Map.Entry<String, String>> entries = def.getSrg2Mcp().entrySet();
        ArrayList<Map.Entry<String, String>> sortedEntries = new ArrayList<Map.Entry<String, String>>(entries);
        sortedEntries.sort(Map.Entry.comparingByValue());
        try (BufferedWriter writer = Files.newBufferedWriter(resolve, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            writer.write(def.getVersion());
            writer.newLine();
            for (Map.Entry entry : sortedEntries) {
                writer.write((String)entry.getKey() + "," + (String)entry.getValue());
                writer.newLine();
            }
        }
        Path baseFile = Paths.get("../blockstate_canvas.json", new String[0]);
        for (Map.Entry entry : sortedEntries) {
            Files.copy(baseFile, path.resolve("assets/mcpaint/blockstates/canvas_" + (String)entry.getValue() + ".json"), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

