/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render.batch.pixel;

import ichttt.mods.mcpaint.client.render.batch.pixel.PixelInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class PixelLine
implements Iterable<PixelInfo> {
    private static final boolean DEBUG = Boolean.getBoolean("mcpaint.pixelline.debug");
    private final int y;
    public final List<PixelInfo> pixelInfos = new ArrayList<PixelInfo>();

    public PixelLine(PixelInfo info) {
        this.pixelInfos.add(info);
        this.y = info.y;
    }

    public boolean canAdd(PixelInfo info) {
        if (info.y != this.y) {
            return false;
        }
        for (PixelInfo info1 : this.pixelInfos) {
            if (!info1.isNeighbourX(info)) continue;
            return true;
        }
        return false;
    }

    public void add(PixelInfo info) {
        if (DEBUG && !this.canAdd(info)) {
            throw new IllegalArgumentException("Cannot add pixel!");
        }
        this.pixelInfos.add(info);
    }

    @Override
    @Nonnull
    public Iterator<PixelInfo> iterator() {
        return this.pixelInfos.iterator();
    }

    public boolean isNeighbour(PixelLine line) {
        if (this.pixelInfos.size() != line.pixelInfos.size()) {
            return false;
        }
        if (!this.isNeighbourY(line)) {
            return false;
        }
        return line.pixelInfos.stream().allMatch(externalPixel -> this.pixelInfos.stream().anyMatch(internalPixel -> internalPixel.x == externalPixel.x));
    }

    private boolean isNeighbourY(PixelLine line) {
        return Math.abs(line.y - this.y) == 1;
    }

    public void addAll(PixelLine infos) {
        if (DEBUG) {
            for (PixelInfo info : infos.pixelInfos) {
                this.add(info);
            }
        } else {
            this.pixelInfos.addAll(infos.pixelInfos);
        }
    }

    public int size() {
        return this.pixelInfos.size();
    }
}

