/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.block;

import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockCanvas
extends Block
implements EntityBlock {
    public static final BooleanProperty SOLID = BooleanProperty.m_61465_((String)"solid");
    public static final BooleanProperty NORMAL_CUBE = BooleanProperty.m_61465_((String)"normal_cube");

    public BlockCanvas(Material material) {
        super(BlockBehaviour.Properties.m_60939_((Material)material).m_60913_(1.0f, 4.0f).m_60924_((state, world, pos) -> (Boolean)state.m_61143_((Property)NORMAL_CUBE)));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SOLID, (Comparable)Boolean.valueOf(true))).m_61124_((Property)NORMAL_CUBE, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityCanvas(pos, state);
    }

    @Nonnull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().m_60625_(player, world, pos);
        }
        return super.m_5880_(state, player, world, pos);
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().m_60734_().getExplosionResistance(canvas.getContainedState(), world, pos, explosion);
        }
        return super.getExplosionResistance(state, world, pos, explosion);
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().m_60734_().getSoundType(canvas.getContainedState(), world, pos, entity);
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public void m_6240_(@Nonnull Level world, Player player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        if (te instanceof TileEntityCanvas) {
            TileEntityCanvas canvas = (TileEntityCanvas)te;
            if (((TileEntityCanvas)te).getContainedState() != null) {
                state = canvas.getContainedState();
                state.m_60734_().m_6240_(world, player, pos, state, te, stack);
                return;
            }
        }
        super.m_6240_(world, player, pos, state, te, stack);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            return state.m_60734_().canHarvestBlock(state, world, pos, player);
        }
        return super.canHarvestBlock(state, world, pos, player);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().m_60742_(world, pos, context);
        }
        return super.m_5939_(state, world, pos, context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().m_60651_(world, pos, context);
        }
        return super.m_5940_(state, world, pos, context);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().m_60816_(world, pos);
        }
        return super.m_7952_(state, world, pos);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        TileEntityCanvas canvas;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileEntityCanvas && (canvas = (TileEntityCanvas)te).getContainedState() != null) {
            return canvas.getContainedState().m_60771_(world, pos, context);
        }
        return super.m_5909_(state, world, pos, context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SOLID, NORMAL_CUBE});
    }

    @Nonnull
    public ItemStack getCloneItemStack(@Nonnull BlockState state, HitResult target, @Nonnull BlockGetter world, @Nonnull BlockPos pos, Player player) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            return state.getCloneItemStack(target, world, pos, player);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            return state.m_60631_(world, pos);
        }
        return super.m_7420_(state, world, pos);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            state.m_60734_().m_214162_(state, world, pos, random);
            return;
        }
        super.m_214162_(state, world, pos, random);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        TileEntityCanvas canvas;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileEntityCanvas && (canvas = (TileEntityCanvas)te).getContainedState() != null) {
            state = canvas.getContainedState();
            return state.getLightEmission(world, pos);
        }
        return super.getLightEmission(state, world, pos);
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float pFallDistance) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            state.m_60734_().m_142072_(world, canvas.getContainedState(), pos, entity, pFallDistance);
            return;
        }
        super.m_142072_(world, state, pos, entity, pFallDistance);
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            return state.m_60838_(world, pos);
        }
        return super.m_180643_(state, world, pos);
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            return state.m_60816_(world, pos);
        }
        return super.m_7947_(state, world, pos);
    }

    public boolean m_222958_(BlockState state, BlockGetter world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            return state.m_60734_().m_222958_(state, world, pos);
        }
        return super.m_222958_(state, world, pos);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            return state.m_60820_(world, pos);
        }
        return super.m_6079_(state, world, pos);
    }

    public boolean hidesNeighborFace(BlockGetter world, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.getExistingBlockEntity(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            return state.m_60734_().hidesNeighborFace(world, pos, state, neighborState, dir);
        }
        return super.hidesNeighborFace(world, pos, state, neighborState, dir);
    }

    public BlockState getStateFrom(BlockGetter world, BlockPos pos, BlockState state) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)SOLID, (Comparable)Boolean.valueOf(state.m_60815_()))).m_61124_((Property)NORMAL_CUBE, (Comparable)Boolean.valueOf(state.m_60796_(world, pos)));
    }
}

