/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.item;

import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.client.ClientHooks;
import ichttt.mods.mcpaint.common.MCPaintUtil;
import ichttt.mods.mcpaint.common.block.BlockCanvas;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.CapabilityPaintable;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.common.item.ItemBrush;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class ItemStamp
extends ItemBrush {
    @Override
    protected InteractionResult processMiss(Level world, Player player, InteractionHand hand, ItemStack stack, @Nullable HitResult result) {
        if ((result == null || result.m_6662_() == HitResult.Type.MISS) && player.m_20089_() == Pose.CROUCHING) {
            IPaintable paint = (IPaintable)stack.getCapability(CapabilityPaintable.PAINTABLE, null).orElseThrow(() -> new RuntimeException("Paintable cap needs to be present!"));
            if (!paint.hasPaintData()) {
                return InteractionResult.PASS;
            }
            paint.clear(null, null);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected InteractionResult processHit(Level world, Player player, InteractionHand hand, BlockPos pos, BlockState state, Direction facing) {
        ItemStack held = player == null ? ItemStack.f_41583_ : player.m_21120_(hand);
        IPaintable paint = Objects.requireNonNull((IPaintable)held.getCapability(CapabilityPaintable.PAINTABLE, null).orElseThrow(() -> new RuntimeException("Missing paint on brush!")));
        if (paint.hasPaintData()) {
            return super.processHit(world, player, hand, pos, state, facing);
        }
        if (player != null && player.m_20089_() == Pose.CROUCHING) {
            TileEntityCanvas canvas;
            BlockEntity te;
            facing = facing.m_122424_();
            if (state.m_60734_() instanceof BlockCanvas && (te = world.m_7702_(pos)) instanceof TileEntityCanvas && (canvas = (TileEntityCanvas)te).hasPaintFor(facing)) {
                paint.copyFrom(canvas.getPaintFor(facing), canvas, facing);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    @Override
    protected void startPainting(TileEntityCanvas canvas, Level world, ItemStack heldItem, BlockPos pos, Direction facing, BlockState state) {
        if (world.f_46443_) {
            IPaintable heldPaint = Objects.requireNonNull((IPaintable)heldItem.getCapability(CapabilityPaintable.PAINTABLE, null).orElseThrow(() -> new RuntimeException("No paint in stamp")));
            if (((Boolean)MCPaintConfig.CLIENT.directApplyStamp.get()).booleanValue()) {
                canvas.getPaintFor(facing).copyFrom(heldPaint, canvas, facing);
                MCPaintUtil.uploadPictureToServer(canvas, facing, heldPaint.getScaleFactor(), heldPaint.getPictureData(true), false);
            } else {
                LinkedList<IPaintable> paintList = new LinkedList<IPaintable>();
                if (canvas.hasPaintFor(facing)) {
                    paintList.add(canvas.getPaintFor(facing));
                }
                paintList.add(heldPaint);
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHooks.showGuiDraw(paintList, pos, facing, canvas.getContainedState()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        IPaintable paintable = (IPaintable)stack.getCapability(CapabilityPaintable.PAINTABLE, null).orElse(null);
        if (paintable != null && paintable.hasPaintData()) {
            tooltip.add((Component)Component.m_237115_((String)"mcpaint.tooltip.stamp.paint"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"mcpaint.tooltip.stamp.nopaint"));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt != null) {
            IPaintable paint = (IPaintable)stack.getCapability(CapabilityPaintable.PAINTABLE).orElseThrow(() -> new IllegalArgumentException("Missing paintable on brush!"));
            CapabilityPaintable.readFromNBT(paint, nbt);
        }
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        IPaintable paint = (IPaintable)stack.getCapability(CapabilityPaintable.PAINTABLE).orElseThrow(() -> new IllegalArgumentException("Missing paintable on brush!"));
        return CapabilityPaintable.writeToNBT(paint, new CompoundTag());
    }
}

