/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client;

import ichttt.mods.mcpaint.client.ClientHooks;
import ichttt.mods.mcpaint.client.delegators.BlockColorDelegator;
import ichttt.mods.mcpaint.client.delegators.DelegatingBakedModel;
import ichttt.mods.mcpaint.client.render.ISTERStamp;
import ichttt.mods.mcpaint.client.render.RenderTypeHandler;
import ichttt.mods.mcpaint.client.render.TERCanvas;
import ichttt.mods.mcpaint.client.render.batch.RenderCache;
import ichttt.mods.mcpaint.common.RegistryObjects;
import java.util.Objects;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientEventHandler {
    public static void earlySetup() {
        MinecraftForge.EVENT_BUS.register(ClientEventHandler.class);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ClientEventHandler::onModelBake);
        bus.addListener(ClientEventHandler::registerModels);
        bus.addListener(ClientEventHandler::setupClient);
        bus.addListener(ClientEventHandler::onRegisterRenders);
        bus.addListener(ClientEventHandler::onRegisterColorHandlers);
    }

    public static void setupClient(FMLClientSetupEvent event) {
        event.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> RenderTypeHandler.CANVAS.toString()));
    }

    public static void registerModels(ModelEvent.RegisterGeometryLoaders event) {
        ItemProperties.register((Item)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mcpaint", "stamp")), "Did not find stamp"), (ResourceLocation)new ResourceLocation("mcpaint", "shift"), (ItemPropertyFunction)ISTERStamp.INSTANCE);
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            RenderCache.clear();
        }
    }

    @SubscribeEvent
    public static void onConfigChange(ModConfigEvent.Reloading event) {
        ClientHooks.onConfigReload();
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfigEvent.Loading event) {
        ClientHooks.onConfigReload();
    }

    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        String[] variants;
        ResourceLocation toReplace = RegistryObjects.CANVAS_BLOCK.getId();
        for (String variant : variants = new String[]{"normal_cube=false,solid=false", "normal_cube=true,solid=false", "normal_cube=false,solid=true", "normal_cube=true,solid=true"}) {
            ModelResourceLocation mrl = new ModelResourceLocation(toReplace, variant);
            Object model = (BakedModel)event.getModels().get(mrl);
            if (model == null) {
                throw new NullPointerException("Model for " + mrl);
            }
            model = new DelegatingBakedModel((BakedModel)model);
            event.getModels().put(mrl, model);
        }
    }

    public static void onRegisterRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)RegistryObjects.CANVAS_BE.get(), TERCanvas::new);
    }

    public static void onRegisterColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((BlockColor)new BlockColorDelegator(), new Block[]{(Block)RegistryObjects.CANVAS_BLOCK.get()});
    }
}

