/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.gui;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.client.gui.IDrawGuiCallback;
import ichttt.mods.mcpaint.client.gui.drawutil.EnumDrawType;
import ichttt.mods.mcpaint.client.gui.drawutil.PictureState;
import ichttt.mods.mcpaint.client.render.RenderUtil;
import ichttt.mods.mcpaint.common.MCPaintUtil;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.networking.MessageDrawAbort;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;

public class DrawScreenHelper {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    public static final int ZERO_ALPHA = new Color(255, 255, 255, 0).getRGB();
    public final BlockPos pos;
    public final Direction facing;
    public final BlockState state;
    public final BakedModel model;
    public final LinkedList<PictureState> statesForUndo = new LinkedList();
    public final LinkedList<PictureState> statesForRedo = new LinkedList();
    public final boolean hadPaint;
    private final IDrawGuiCallback callback;
    public Color color = Color.BLACK;
    public int toolSize = 1;
    private PictureState paintingState;
    private PictureState currentState;
    private boolean clickStartedInPicture = false;
    private EnumDrawType activeDrawType = EnumDrawType.PENCIL;
    private boolean hasSizeWindow;
    private boolean noRevert = false;
    private boolean updating = false;

    public DrawScreenHelper(IPaintable canvas, List<IPaintable> prevImages, BlockPos pos, Direction facing, BlockState state, IDrawGuiCallback callback) {
        this.callback = callback;
        Objects.requireNonNull(canvas, "Canvas is null");
        Preconditions.checkArgument((boolean)canvas.hasPaintData(), (Object)"No data in canvas");
        this.pos = pos;
        this.facing = facing;
        this.state = state;
        this.model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        this.currentState = new PictureState(canvas);
        for (IPaintable paint : prevImages) {
            this.statesForUndo.add(new PictureState(paint));
        }
        this.hadPaint = true;
    }

    protected DrawScreenHelper(byte scaleFactor, BlockPos pos, Direction facing, BlockState state, IDrawGuiCallback callback) {
        int[][] picture;
        this.pos = Objects.requireNonNull(pos);
        this.facing = facing;
        this.state = state;
        this.model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        this.callback = callback;
        for (int[] tileArray : picture = new int[128 / scaleFactor][128 / scaleFactor]) {
            Arrays.fill(tileArray, ZERO_ALPHA);
        }
        this.currentState = new PictureState(picture, scaleFactor);
        this.hadPaint = false;
    }

    private void init() {
        this.hasSizeWindow = false;
    }

    public void saveImage() {
        try {
            this.saveImage(true);
        }
        catch (IOException e) {
            MCPaint.LOGGER.error("Could not save image!", (Throwable)e);
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.f_91074_.m_5661_((Component)Component.m_237113_((String)"Failed to save file!"), true);
            minecraft.f_91074_.m_5661_((Component)Component.m_237113_((String)"Failed to save file!"), false);
        }
    }

    public void rotateRight() {
        int[][] newData = new int[this.currentState.picture.length][this.currentState.picture[0].length];
        for (int x = 0; x < this.currentState.picture.length; ++x) {
            int[] yData = this.currentState.picture[x];
            for (int y = 0; y < yData.length; ++y) {
                newData[yData.length - y - 1][x] = yData[y];
            }
        }
        this.newPictureState(new PictureState(newData, this.currentState.scaleFactor));
    }

    public void rotateLeft() {
        int[][] newData = new int[this.currentState.picture.length][this.currentState.picture[0].length];
        for (int x = 0; x < this.currentState.picture.length; ++x) {
            int[] yData = this.currentState.picture[x];
            for (int y = 0; y < yData.length; ++y) {
                newData[y][this.currentState.picture.length - x - 1] = yData[y];
            }
        }
        this.newPictureState(new PictureState(newData, this.currentState.scaleFactor));
    }

    public void saveAndClose() {
        Minecraft mc = Minecraft.m_91087_();
        if (Arrays.stream(this.currentState.picture).anyMatch(ints -> Arrays.stream(ints).anyMatch(value -> value != ZERO_ALPHA))) {
            this.noRevert = true;
            MCPaintUtil.uploadPictureToServer(mc.f_91073_.m_7702_(this.pos), this.facing, this.currentState.scaleFactor, this.currentState.picture, false);
        } else if (this.hadPaint) {
            MCPaintUtil.uploadPictureToServer(mc.f_91073_.m_7702_(this.pos), this.facing, this.currentState.scaleFactor, this.currentState.picture, true);
        }
        mc.m_91152_(null);
    }

    public void onClose() {
        if (!this.noRevert) {
            MCPaint.NETWORKING.sendToServer((Object)new MessageDrawAbort(this.pos));
        }
    }

    public void renderBackgroundBlock(GuiGraphics guiGraphics, int startLeft, int startTop) {
        Minecraft mc = Minecraft.m_91087_();
        RandomSource randomSource = RandomSource.m_216327_();
        ChunkRenderTypeSet renderTypes = this.model.getRenderTypes(this.state, randomSource, ModelData.EMPTY);
        PoseStack stack = guiGraphics.m_280168_();
        for (RenderType renderType : renderTypes) {
            List quads = this.model.getQuads(this.state, this.facing.m_122424_(), randomSource, ModelData.EMPTY, renderType);
            for (BakedQuad quad : quads) {
                TextureAtlasSprite sprite = quad.m_173410_();
                stack.m_85836_();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
                if (quad.m_111304_()) {
                    int color = mc.m_91298_().m_92577_(this.state, (BlockAndTintGetter)mc.f_91073_, this.pos, quad.m_111305_());
                    float red = (float)(color >> 16 & 0xFF) / 255.0f;
                    float green = (float)(color >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(color & 0xFF) / 255.0f;
                    RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
                }
                guiGraphics.m_280159_(startLeft, startTop, -1, 128, 128, sprite);
                stack.m_85849_();
            }
        }
    }

    public void renderImage(GuiGraphics graphics, int startLeft, int startTop, int[][] toDraw) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderUtil.renderInGui(graphics.m_280168_().m_85850_().m_252922_(), startLeft, startTop, this.currentState.scaleFactor, buffer, toDraw);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public boolean switchToolButton(EnumDrawType newDrawType) {
        this.activeDrawType = newDrawType;
        boolean hadSizeWindow = this.hasSizeWindow;
        this.hasSizeWindow = this.activeDrawType.hasSizeRegulator;
        return hadSizeWindow;
    }

    public boolean handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        if (this.handleMouse(mouseX, mouseY, mouseButton)) {
            this.clickStartedInPicture = true;
            return true;
        }
        return false;
    }

    public boolean handleMouseDragged(double mouseX, double mouseY, int mouseButton) {
        return this.clickStartedInPicture && this.handleMouse(mouseX, mouseY, mouseButton);
    }

    public void handleMouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.clickStartedInPicture = false;
        if (this.paintingState != null) {
            this.newPictureState(this.paintingState);
            this.paintingState = null;
        }
    }

    private void newPictureState(PictureState state) {
        if (state.isSame(this.currentState)) {
            return;
        }
        this.statesForRedo.clear();
        this.statesForUndo.add(this.currentState);
        this.currentState = state;
        if (this.statesForUndo.size() > 20) {
            this.statesForUndo.removeFirst();
        }
        this.callback.updateUndoRedoButton(!this.statesForUndo.isEmpty(), !this.statesForRedo.isEmpty());
    }

    public void undo() {
        if (this.statesForUndo.size() > 0) {
            this.statesForRedo.add(this.currentState);
            this.currentState = this.statesForUndo.removeLast();
        }
        this.callback.updateUndoRedoButton(!this.statesForUndo.isEmpty(), !this.statesForRedo.isEmpty());
    }

    public void redo() {
        if (this.statesForRedo.size() > 0) {
            this.statesForUndo.add(this.currentState);
            this.currentState = this.statesForRedo.removeLast();
        }
        this.callback.updateUndoRedoButton(!this.statesForUndo.isEmpty(), !this.statesForRedo.isEmpty());
    }

    private boolean handleMouse(double mouseXD, double mouseYD, int mouseButton) {
        int offsetMouseY;
        if (mouseButton != 0) {
            return false;
        }
        int mouseX = (int)Math.round(mouseXD);
        int mouseY = (int)Math.round(mouseYD);
        int offsetMouseX = this.callback.offsetMouseX(mouseX);
        if (this.callback.isInPicture(offsetMouseX, offsetMouseY = this.callback.offsetMouseY(mouseY))) {
            int pixelPosX = offsetMouseX / this.currentState.scaleFactor;
            int pixelPosY = offsetMouseY / this.currentState.scaleFactor;
            if (this.paintingState == null) {
                this.paintingState = new PictureState(this.currentState);
            }
            if (pixelPosX < this.paintingState.picture.length && pixelPosY < this.paintingState.picture.length && this.color != null) {
                this.color = this.activeDrawType.draw(this.paintingState.picture, this.color, pixelPosX, pixelPosY, this.toolSize);
                this.callback.updateSliders();
                return true;
            }
        }
        return false;
    }

    private ResourceLocation getResourceLocation(TextureAtlasSprite p_184396_1_) {
        ResourceLocation resourcelocation = p_184396_1_.m_247685_();
        return new ResourceLocation(resourcelocation.m_135827_(), String.format("textures/%s%s", resourcelocation.m_135815_(), ".png"));
    }

    private void saveImage(boolean background) throws IOException {
        Minecraft minecraft = Minecraft.m_91087_();
        BufferedImage paint = new BufferedImage(128 / this.currentState.scaleFactor, 128 / this.currentState.scaleFactor, 2);
        for (int x = 0; x < this.currentState.picture.length; ++x) {
            for (int y = 0; y < this.currentState.picture[0].length; ++y) {
                paint.setRGB(x, y, this.currentState.picture[x][y]);
            }
        }
        BufferedImage output = new BufferedImage(paint.getWidth(), paint.getHeight(), 2);
        if (background) {
            RandomSource randomSource = RandomSource.m_216327_();
            ChunkRenderTypeSet renderTypes = this.model.getRenderTypes(this.state, randomSource, ModelData.EMPTY);
            for (RenderType renderType : renderTypes) {
                List quads = this.model.getQuads(this.state, this.facing.m_122424_(), randomSource, ModelData.EMPTY, renderType);
                for (BakedQuad quad : quads) {
                    TextureAtlasSprite sprite = quad.m_173410_();
                    InputStream stream = minecraft.m_91098_().m_215595_(this.getResourceLocation(sprite));
                    try {
                        Image image = ImageIO.read(stream);
                        if (quad.m_111304_()) {
                            int color = minecraft.m_91298_().m_92577_(this.state, (BlockAndTintGetter)minecraft.f_91073_, this.pos, quad.m_111305_());
                            float red = (float)(color >> 16 & 0xFF) / 255.0f;
                            float green = (float)(color >> 8 & 0xFF) / 255.0f;
                            float blue = (float)(color & 0xFF) / 255.0f;
                            Image asBufferedImage = image;
                            for (int x = 0; x < ((BufferedImage)asBufferedImage).getWidth(); ++x) {
                                for (int y = 0; y < ((BufferedImage)asBufferedImage).getHeight(); ++y) {
                                    Color originalColor = new Color(((BufferedImage)asBufferedImage).getRGB(x, y), true);
                                    int newRed = Math.round((float)originalColor.getRed() * red);
                                    int newGreen = Math.round((float)originalColor.getGreen() * green);
                                    int newBlue = Math.round((float)originalColor.getBlue() * blue);
                                    ((BufferedImage)asBufferedImage).setRGB(x, y, new Color(newRed, newGreen, newBlue, originalColor.getAlpha()).getRGB());
                                }
                            }
                        }
                        image = image.getScaledInstance(output.getWidth(), output.getHeight(), 2);
                        output.getGraphics().drawImage(image, 0, 0, null);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
            }
        }
        output.getGraphics().drawImage(paint, 0, 0, null);
        File file = new File(minecraft.f_91069_, "paintings");
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("Could not create folder");
        }
        File finalFile = DrawScreenHelper.getTimestampedPNGFileForDirectory(file);
        if (!ImageIO.write((RenderedImage)output, "png", finalFile)) {
            throw new IOException("Could not encode image as png!");
        }
        MutableComponent component = Component.m_237113_((String)finalFile.getName());
        component = component.m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, finalFile.getAbsolutePath())));
        minecraft.f_91074_.m_5661_((Component)Component.m_237110_((String)"mcpaint.gui.saved", (Object[])new Object[]{component}), false);
    }

    private static File getTimestampedPNGFileForDirectory(File gameDirectory) {
        String s = DATE_FORMAT.format(new Date());
        int i = 1;
        File file1;
        while ((file1 = new File(gameDirectory, s + (String)(i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file1;
    }

    public EnumDrawType activeDrawType() {
        return this.activeDrawType;
    }

    public boolean hasSizeWindow() {
        return this.hasSizeWindow;
    }

    public PictureState currentState() {
        return this.currentState;
    }

    public int[][] getBasePicture() {
        return this.paintingState == null ? this.currentState.picture : this.paintingState.picture;
    }
}

