/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common;

import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.networking.MessageClearSide;
import ichttt.mods.mcpaint.networking.MessagePaintData;
import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import it.unimi.dsi.fastutil.ints.Int2ByteOpenHashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class MCPaintUtil {
    public static boolean isPosInvalid(ServerPlayer player, BlockPos pos) {
        if (!player.m_9236_().m_46805_(pos)) {
            MCPaint.LOGGER.warn("Player" + player.m_7755_() + " is trying to write to unloaded block");
            player.f_8906_.m_9942_((Component)Component.m_237113_((String)"Trying to write to unloaded block"));
            return true;
        }
        if (Math.sqrt(player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) > (double)(Math.round(player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_()) + 5L)) {
            MCPaint.LOGGER.warn("Player" + player.m_7755_() + " is writing to out of reach block!");
            return true;
        }
        return false;
    }

    public static int[][] copyOf(int[][] array) {
        int[][] copy = new int[array.length][];
        for (int i = 0; i < array.length; ++i) {
            copy[i] = (int[])array[i].clone();
        }
        return copy;
    }

    public static boolean[][] copyOf(boolean[][] array) {
        boolean[][] copy = new boolean[array.length][];
        for (int i = 0; i < array.length; ++i) {
            copy[i] = (boolean[])array[i].clone();
        }
        return copy;
    }

    public static void uploadPictureToServer(@Nullable BlockEntity te, Direction facing, byte scaleFactor, int[][] picture, boolean clear) {
        if (!(te instanceof TileEntityCanvas)) {
            MCPaint.LOGGER.error("Could not set paint! Found block " + (te == null ? "NONE" : te.m_58903_()));
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)"Could not set paint!"), true);
            return;
        }
        TileEntityCanvas canvas = (TileEntityCanvas)te;
        if (clear) {
            MCPaint.NETWORKING.sendToServer((Object)new MessageClearSide(te.m_58899_(), facing));
            canvas.removePaint(facing);
        } else {
            IPaintable paintable = canvas.getPaintFor(facing);
            paintable.setData(scaleFactor, picture, canvas, facing);
            MessagePaintData.createAndSend(te.m_58899_(), facing, scaleFactor, paintable.getPalette(), picture, arg_0 -> ((SimpleChannel)MCPaint.NETWORKING).sendToServer(arg_0));
        }
    }

    @Nonnull
    public static ServerPlayer checkServer(NetworkEvent.Context context) {
        if (context.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            throw new IllegalArgumentException("Wrong side for server packet handler " + context.getDirection());
        }
        context.setPacketHandled(true);
        return Objects.requireNonNull(context.getSender());
    }

    public static void checkClient(NetworkEvent.Context context) {
        if (context.getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            throw new IllegalArgumentException("Wrong side for client packet handler: " + context.getDirection());
        }
        context.setPacketHandled(true);
    }

    public static Int2ByteMap buildReversePalette(int[] palette) {
        Int2ByteOpenHashMap map = new Int2ByteOpenHashMap();
        for (int i = 0; i < palette.length; ++i) {
            map.put(palette[i], (byte)i);
        }
        return map;
    }
}

