/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.block;

import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BlockCanvas
extends Block
implements EntityBlock {
    public static final BooleanProperty SOLID = BooleanProperty.m_61465_((String)"solid");
    public static final BooleanProperty NORMAL_CUBE = BooleanProperty.m_61465_((String)"normal_cube");

    private static BlockState getContainedState(BlockGetter levelAccessor, BlockPos pos) {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer != null && !currentServer.m_18695_() && levelAccessor instanceof ServerLevel && currentServer.m_129928_() == null) {
            return null;
        }
        BlockEntity blockEntity = levelAccessor.getExistingBlockEntity(pos);
        if (blockEntity instanceof TileEntityCanvas) {
            TileEntityCanvas canvas = (TileEntityCanvas)blockEntity;
            return canvas.getContainedState();
        }
        return null;
    }

    private static boolean canRenderEmissiveProp(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60788_(level, pos);
        }
        return false;
    }

    private static boolean isValidSpawnProp(BlockState state, BlockGetter level, BlockPos pos, EntityType<?> entityType) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60643_(level, pos, entityType);
        }
        return state.m_60783_(level, pos, Direction.UP) && state.getLightEmission(level, pos) < 14;
    }

    private static boolean isSuffocatingProp(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60828_(level, pos);
        }
        return state.m_280555_() && state.m_60838_(level, pos);
    }

    private static boolean isRedstoneConductorProp(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60796_(level, pos);
        }
        return state.m_60838_(level, pos);
    }

    public BlockCanvas() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(1.0f, 4.0f).m_60924_(BlockCanvas::isRedstoneConductorProp).m_60991_(BlockCanvas::canRenderEmissiveProp).m_60922_(BlockCanvas::isValidSpawnProp).m_60960_(BlockCanvas::isSuffocatingProp).m_60988_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SOLID, (Comparable)Boolean.valueOf(true))).m_61124_((Property)NORMAL_CUBE, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityCanvas(pos, state);
    }

    @Nonnull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60625_(player, level, pos);
        }
        return super.m_5880_(state, player, level, pos);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.getExplosionResistance(level, pos, explosion);
        }
        return super.getExplosionResistance(state, level, pos, explosion);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        BlockState containedState = BlockCanvas.getContainedState((BlockGetter)level, pos);
        if (containedState != null) {
            return containedState.getSoundType(level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public void m_6240_(@Nonnull Level level, Player player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        TileEntityCanvas canvas;
        BlockState containedState;
        if (te instanceof TileEntityCanvas && (containedState = (canvas = (TileEntityCanvas)te).getContainedState()) != null) {
            containedState.m_60734_().m_6240_(level, player, pos, containedState, te, stack);
            return;
        }
        super.m_6240_(level, player, pos, state, te, stack);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.canHarvestBlock(level, pos, player);
        }
        return super.canHarvestBlock(state, level, pos, player);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60742_(level, pos, context);
        }
        return super.m_5939_(state, level, pos, context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60651_(level, pos, context);
        }
        return super.m_5940_(state, level, pos, context);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60816_(level, pos);
        }
        return super.m_7952_(state, level, pos);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60771_(level, pos, context);
        }
        return super.m_5909_(state, level, pos, context);
    }

    @Nonnull
    public ItemStack getCloneItemStack(@Nonnull BlockState state, HitResult target, @Nonnull BlockGetter level, @Nonnull BlockPos pos, Player player) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.getCloneItemStack(target, level, pos, player);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60631_(level, pos);
        }
        return super.m_7420_(state, level, pos);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockState containedState = BlockCanvas.getContainedState((BlockGetter)level, pos);
        if (containedState != null) {
            containedState.m_60734_().m_214162_(containedState, level, pos, random);
            return;
        }
        super.m_214162_(state, level, pos, random);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.getLightEmission(level, pos);
        }
        return super.getLightEmission(state, level, pos);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float pFallDistance) {
        BlockState containedState = BlockCanvas.getContainedState((BlockGetter)level, pos);
        if (containedState != null) {
            containedState.m_60734_().m_142072_(level, containedState, pos, entity, pFallDistance);
            return;
        }
        super.m_142072_(level, state, pos, entity, pFallDistance);
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60838_(level, pos);
        }
        return super.m_180643_(state, level, pos);
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60816_(level, pos);
        }
        return super.m_7947_(state, level, pos);
    }

    public boolean m_222958_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60734_().m_222958_(containedState, level, pos);
        }
        return super.m_222958_(state, level, pos);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60820_(level, pos);
        }
        return super.m_6079_(state, level, pos);
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60734_().hidesNeighborFace(level, pos, containedState, neighborState, dir);
        }
        return super.hidesNeighborFace(level, pos, state, neighborState, dir);
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_284242_(level, pos);
        }
        return super.getMapColor(state, level, pos, defaultColor);
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState containedState = BlockCanvas.getContainedState(level, pos);
        if (containedState != null) {
            return containedState.m_60739_(level, pos);
        }
        return super.m_7753_(state, level, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SOLID, NORMAL_CUBE});
    }

    public BlockState getStateFrom(BlockGetter world, BlockPos pos, BlockState state) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)SOLID, (Comparable)Boolean.valueOf(state.m_60815_()))).m_61124_((Property)NORMAL_CUBE, (Comparable)Boolean.valueOf(state.m_60796_(world, pos)));
    }
}

