/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.networking;

import ichttt.mods.mcpaint.common.MCPaintUtil;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class MessageDrawAbort {
    private final BlockPos pos;

    public MessageDrawAbort(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
    }

    public MessageDrawAbort(BlockPos pos) {
        this.pos = pos;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    public static class Handler {
        public static void onMessage(MessageDrawAbort message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            ServerPlayer player = MCPaintUtil.checkServer(ctx);
            ctx.setPacketHandled(true);
            ctx.enqueueWork(() -> {
                if (MCPaintUtil.isPosInvalid(player, message.pos)) {
                    return;
                }
                BlockEntity te = player.m_9236_().m_7702_(message.pos);
                if (te instanceof TileEntityCanvas) {
                    TileEntityCanvas canvas = (TileEntityCanvas)te;
                    boolean hasData = false;
                    for (Direction facing : Direction.values()) {
                        if (!canvas.hasPaintFor(facing)) continue;
                        hasData = true;
                        break;
                    }
                    if (!hasData && canvas.getContainedState() != null) {
                        player.m_9236_().m_46597_(message.pos, canvas.getContainedState());
                    }
                }
            });
        }
    }
}

