/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.networking;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.primitives.Shorts;
import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.common.MCPaintUtil;
import ichttt.mods.mcpaint.common.block.BlockCanvas;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.networking.MessageClearSide;
import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MessagePaintData {
    private final BlockPos pos;
    private final Direction facing;
    private final byte scale;
    private final byte part;
    private final byte maxParts;
    private final int[][] data;
    private final int[] palette;

    public static void createAndSend(BlockPos pos, Direction facing, byte scale, int[] palette, int[][] data, Consumer<MessagePaintData> sender) {
        int length = data.length;
        if (length > 0) {
            length *= data[0].length;
        }
        if (length > 32000 || palette == null && length > 8000) {
            int partsAsInt = length / 32000 + 1;
            while (data.length % partsAsInt != 0) {
                if (++partsAsInt <= 32) continue;
                throw new RuntimeException("Hell I'm not sending " + partsAsInt + "+ packets for a single image of length " + length);
            }
            if (partsAsInt > 127) {
                throw new IllegalArgumentException("Picture too large: " + length);
            }
            byte parts = (byte)partsAsInt;
            for (byte b = 1; b <= parts; b = (byte)(b + 1)) {
                MessagePaintData toSend = new MessagePaintData(pos, facing, scale, palette, data, b, parts);
                sender.accept(toSend);
            }
        } else {
            MessagePaintData toSend = new MessagePaintData(pos, facing, scale, palette, data, 0, 0);
            sender.accept(toSend);
        }
    }

    public MessagePaintData(BlockPos pos, Direction facing, byte scale, int[] palette, int[][] data, byte part, byte maxParts) {
        this.pos = pos;
        this.facing = facing;
        this.scale = scale;
        this.palette = palette;
        this.data = data;
        this.part = part;
        this.maxParts = maxParts;
    }

    public MessagePaintData(FriendlyByteBuf buf) {
        int i;
        this.pos = buf.m_130135_();
        this.scale = buf.readByte();
        this.facing = Direction.m_122376_((int)buf.readByte());
        this.part = buf.readByte();
        this.maxParts = buf.readByte();
        int max = buf.readShort();
        int secondMax = buf.readShort();
        int paletteLength = buf.readByte();
        if (paletteLength <= 0) {
            this.palette = null;
        } else {
            this.palette = new int[paletteLength];
            for (i = 0; i < paletteLength; ++i) {
                this.palette[i] = buf.readInt();
            }
        }
        this.data = new int[max][secondMax];
        for (i = 0; i < max; ++i) {
            for (int j = 0; j < secondMax; ++j) {
                this.data[i][j] = this.palette == null ? buf.readInt() : this.palette[buf.readByte()];
            }
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeByte((int)this.scale);
        buf.writeByte(this.facing.m_122411_());
        buf.writeByte((int)this.part);
        buf.writeByte((int)this.maxParts);
        int max = Shorts.checkedCast((long)(this.maxParts == 0 ? (long)this.data.length : (long)(this.data.length / this.maxParts)));
        buf.writeShort((int)Shorts.checkedCast((long)max));
        buf.writeShort((int)Shorts.checkedCast((long)this.data[0].length));
        buf.writeByte(this.palette == null ? 0 : this.palette.length);
        Int2ByteMap reversePalette = null;
        if (this.palette != null) {
            for (int i : this.palette) {
                buf.writeInt(i);
            }
            reversePalette = MCPaintUtil.buildReversePalette(this.palette);
        }
        int offset = this.maxParts == 0 ? max : max * this.part;
        for (int i = offset - max; i < offset; ++i) {
            int[] subarray;
            for (int value : subarray = this.data[i]) {
                if (this.palette != null) {
                    buf.writeByte((int)reversePalette.get(value));
                    continue;
                }
                buf.writeInt(value);
            }
        }
    }

    public static class ClientMessage
    extends MessagePaintData {
        public ClientMessage(MessagePaintData msg) {
            super(msg.pos, msg.facing, msg.scale, msg.palette, msg.data, msg.part, msg.maxParts);
        }

        public ClientMessage(FriendlyByteBuf buf) {
            super(buf);
        }
    }

    public static class ClientHandler
    extends ServerHandler {
        public static final ClientHandler INSTANCE = new ClientHandler();

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void handleSide(NetworkEvent.Context ctx, BlockPos pos, Direction facing, byte scale, int[] palette, int[][] data) {
            BlockEntity te;
            MCPaintUtil.checkClient(ctx);
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (!world.m_46805_(pos)) {
                MCPaint.LOGGER.warn("Invalid pos " + pos + " when updating data - Not loaded");
            }
            if (!((te = world.m_7702_(pos)) instanceof TileEntityCanvas)) {
                MCPaint.LOGGER.warn("Invalid block at pos " + pos + " when updating data - TE invalid");
                return;
            }
            TileEntityCanvas canvas = (TileEntityCanvas)te;
            canvas.getPaintFor(facing).setDataWithPalette(scale, data, palette, canvas, facing);
            te.m_6596_();
        }
    }

    public static class ServerHandler {
        public static final ServerHandler INSTANCE = new ServerHandler();
        private final Multimap<BlockPos, MessagePaintData> partMap = MultimapBuilder.hashKeys().hashSetValues().build();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(MessagePaintData message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            ctx.setPacketHandled(true);
            if (message.maxParts == 0) {
                ctx.enqueueWork(() -> this.handleSide(ctx, message.pos, message.facing, message.scale, message.palette, message.data));
            } else {
                Multimap<BlockPos, MessagePaintData> multimap = this.partMap;
                synchronized (multimap) {
                    this.partMap.put((Object)message.pos, (Object)message);
                    Collection messages = this.partMap.get((Object)message.pos);
                    if (messages.size() == message.maxParts) {
                        int[][] data = new int[message.data.length * message.maxParts][message.data[0].length];
                        messages.stream().sorted(Comparator.comparingInt(o -> o.part)).forEachOrdered(messagePaintData -> {
                            int offset = messagePaintData.data.length * (messagePaintData.part - 1);
                            for (int i = 0; i < messagePaintData.data.length; ++i) {
                                int[] subarray = messagePaintData.data[i];
                                System.arraycopy(messagePaintData.data[i], 0, data[i + offset], 0, subarray.length);
                            }
                        });
                        this.partMap.removeAll((Object)message.pos);
                        ctx.enqueueWork(() -> this.handleSide(ctx, message.pos, message.facing, message.scale, message.palette, data));
                    }
                }
            }
        }

        public void handleSide(NetworkEvent.Context ctx, BlockPos pos, Direction facing, byte scale, int[] palette, int[][] data) {
            ServerPlayer player = MCPaintUtil.checkServer(ctx);
            if (MCPaintUtil.isPosInvalid(player, pos)) {
                return;
            }
            BlockState state = player.m_9236_().m_8055_(pos);
            if (!(state.m_60734_() instanceof BlockCanvas)) {
                MCPaint.LOGGER.warn("Invalid block at pos " + pos + " has been selected by player " + player.m_7755_() + " - Block invalid");
                return;
            }
            BlockEntity te = player.m_9236_().m_7702_(pos);
            if (!(te instanceof TileEntityCanvas)) {
                MCPaint.LOGGER.warn("Invalid block at pos " + pos + " has been selected by player " + player.m_7755_() + " - TE invalid");
                return;
            }
            TileEntityCanvas canvas = (TileEntityCanvas)te;
            if (data == null) {
                canvas.removePaint(facing);
            } else {
                canvas.getPaintFor(facing).setDataWithPalette(scale, data, palette, canvas, facing);
            }
            te.m_6596_();
            PacketDistributor.PacketTarget target = PacketDistributor.TRACKING_CHUNK.with(() -> (LevelChunk)Objects.requireNonNull(te.m_58904_()).m_46865_(te.m_58899_()));
            if (data == null) {
                MCPaint.NETWORKING.send(target, (Object)new MessageClearSide.ClientMessage(pos, facing));
            } else {
                MessagePaintData.createAndSend(pos, facing, scale, palette, data, messagePaintData -> MCPaint.NETWORKING.send(target, (Object)new ClientMessage((MessagePaintData)messagePaintData)));
            }
        }
    }
}

