/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import ichttt.mods.mcpaint.client.gui.DrawScreenHelper;
import ichttt.mods.mcpaint.client.gui.IDrawGuiCallback;
import ichttt.mods.mcpaint.client.gui.button.GuiButtonTextToggle;
import ichttt.mods.mcpaint.client.gui.button.GuiColorButton;
import ichttt.mods.mcpaint.client.gui.drawutil.EnumDrawType;
import ichttt.mods.mcpaint.client.gui.drawutil.PictureState;
import ichttt.mods.mcpaint.common.MCPaintUtil;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.gui.widget.Slider;

public class DrawScreen
extends Screen
implements Slider.ISlider,
IDrawGuiCallback {
    private static final int PICTURE_START_LEFT = 6;
    private static final int PICTURE_START_TOP = 9;
    public static final ResourceLocation BACKGROUND = new ResourceLocation("mcpaint", "textures/gui/setup.png");
    private static final int xSize = 176;
    private static final int ySize = 166;
    private static final int toolXSize = 80;
    private static final int toolYSize = 95;
    private static final int sizeXSize = 80;
    private static final int sizeYSize = 34;
    private final DrawScreenHelper helper;
    private int guiLeft;
    private int guiTop;
    private Button undo;
    private Button redo;
    private Button lessSize;
    private Button moreSize;
    private final List<GuiButtonTextToggle> textToggleList = new ArrayList<GuiButtonTextToggle>();
    private Slider redSlider;
    private Slider blueSlider;
    private Slider greenSlider;
    private Slider alphaSlider;
    private boolean updating;

    public DrawScreen(IPaintable canvas, List<IPaintable> prevImages, BlockPos pos, Direction facing, BlockState state) {
        super((Component)new TranslatableComponent("mcpaint.drawgui"));
        this.helper = new DrawScreenHelper(canvas, prevImages, pos, facing, state, this);
    }

    public DrawScreen(byte scaleFactor, BlockPos pos, Direction facing, BlockState state) {
        super((Component)new TranslatableComponent("mcpaint.drawgui"));
        this.helper = new DrawScreenHelper(scaleFactor, pos, facing, state, this);
    }

    public void m_7856_() {
        this.textToggleList.clear();
        this.guiLeft = (this.f_96543_ - 176) / 2;
        this.guiTop = (this.f_96544_ - 166) / 2;
        Button saveImage = new Button(this.guiLeft + 176, this.guiTop + 96, 80, 20, (Component)new TranslatableComponent("mcpaint.gui.export"), button -> this.helper.saveImage());
        Button rotateRight = new Button(this.guiLeft - 80 + 2 + 39, this.guiTop + 5 + 22 + 22 + 22, 36, 20, (Component)new TranslatableComponent("mcpaint.gui.rright"), button -> this.helper.rotateRight());
        Button rotateLeft = new Button(this.guiLeft - 80 + 3, this.guiTop + 5 + 22 + 22 + 22, 36, 20, (Component)new TranslatableComponent("mcpaint.gui.rleft"), button -> this.helper.rotateLeft());
        this.redo = new Button(this.guiLeft - 80 + 2 + 39, this.guiTop + 5 + 22 + 22, 36, 20, (Component)new TranslatableComponent("mcpaint.gui.redo"), button -> this.helper.redo());
        this.undo = new Button(this.guiLeft - 80 + 3, this.guiTop + 5 + 22 + 22, 36, 20, (Component)new TranslatableComponent("mcpaint.gui.undo"), button -> this.helper.undo());
        GuiButtonTextToggle pickColor = new GuiButtonTextToggle(this.guiLeft - 80 + 2 + 39, this.guiTop + 5 + 22, 36, 20, EnumDrawType.PICK_COLOR, this::handleToolButton);
        GuiButtonTextToggle erase = new GuiButtonTextToggle(this.guiLeft - 80 + 3, this.guiTop + 5 + 22, 36, 20, EnumDrawType.ERASER, this::handleToolButton);
        GuiButtonTextToggle fill = new GuiButtonTextToggle(this.guiLeft - 80 + 2 + 39, this.guiTop + 5, 36, 20, EnumDrawType.FILL, this::handleToolButton);
        GuiButtonTextToggle pencil = new GuiButtonTextToggle(this.guiLeft - 80 + 3, this.guiTop + 5, 36, 20, EnumDrawType.PENCIL, this::handleToolButton);
        this.moreSize = new Button(this.guiLeft - 80 + 3 + 55, this.guiTop + 95 + 5, 20, 20, (Component)new TextComponent(">"), button -> {
            ++this.helper.toolSize;
            this.handleSizeChanged();
        });
        this.lessSize = new Button(this.guiLeft - 80 + 3, this.guiTop + 95 + 5, 20, 20, (Component)new TextComponent("<"), button -> {
            --this.helper.toolSize;
            this.handleSizeChanged();
        });
        Button done = new Button(this.guiLeft + 88 - 100, this.guiTop + 166 + 20, 200, 20, (Component)new TranslatableComponent("gui.done"), button -> this.helper.saveAndClose());
        GuiColorButton black = new GuiColorButton(0, this.guiLeft + 137, this.guiTop + 9, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton white = new GuiColorButton(1, this.guiLeft + 137 + 18, this.guiTop + 9, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton gray = new GuiColorButton(2, this.guiLeft + 137, this.guiTop + 9 + 18, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton red = new GuiColorButton(3, this.guiLeft + 137 + 18, this.guiTop + 9 + 18, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton orange = new GuiColorButton(4, this.guiLeft + 137, this.guiTop + 9 + 36, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton yellow = new GuiColorButton(5, this.guiLeft + 137 + 18, this.guiTop + 9 + 36, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton lime = new GuiColorButton(6, this.guiLeft + 137, this.guiTop + 9 + 54, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        GuiColorButton green = new GuiColorButton(7, this.guiLeft + 137 + 18, this.guiTop + 9 + 54, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        GuiColorButton lightBlue = new GuiColorButton(8, this.guiLeft + 137, this.guiTop + 9 + 72, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        GuiColorButton darkBlue = new GuiColorButton(9, this.guiLeft + 137 + 18, this.guiTop + 9 + 72, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        GuiColorButton purple = new GuiColorButton(10, this.guiLeft + 137, this.guiTop + 9 + 90, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        GuiColorButton pink = new GuiColorButton(11, this.guiLeft + 137 + 18, this.guiTop + 9 + 90, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        this.redSlider = this.makeSlider(this.guiLeft + 176 + 3, this.guiTop + 4, "mcpaint.gui.red");
        this.greenSlider = this.makeSlider(this.guiLeft + 176 + 3, this.guiTop + 26, "mcpaint.gui.green");
        this.blueSlider = this.makeSlider(this.guiLeft + 176 + 3, this.guiTop + 48, "mcpaint.gui.blue");
        this.alphaSlider = this.makeSlider(this.guiLeft + 176 + 3, this.guiTop + 70, "mcpaint.gui.alpha");
        this.m_142416_(saveImage);
        this.m_142416_(rotateRight);
        this.m_142416_(rotateLeft);
        this.m_142416_(this.redo);
        this.m_142416_(this.undo);
        this.m_142416_(pickColor);
        this.m_142416_(erase);
        this.m_142416_(fill);
        this.m_142416_(pencil);
        this.m_142416_(done);
        this.m_142416_(black);
        this.m_142416_(white);
        this.m_142416_(gray);
        this.m_142416_(red);
        this.m_142416_(orange);
        this.m_142416_(yellow);
        this.m_142416_(lime);
        this.m_142416_(green);
        this.m_142416_(lightBlue);
        this.m_142416_(darkBlue);
        this.m_142416_(purple);
        this.m_142416_(pink);
        this.m_142416_(this.redSlider);
        this.m_142416_(this.greenSlider);
        this.m_142416_(this.blueSlider);
        this.m_142416_(this.alphaSlider);
        pencil.m_5716_(0.0, 0.0);
        this.lessSize.m_5716_(0.0, 0.0);
        black.m_5716_(0.0, 0.0);
        this.redo.m_5716_(0.0, 0.0);
    }

    protected <T extends GuiEventListener & Widget> T m_142416_(T pWidget) {
        GuiEventListener t = super.m_142416_(pWidget);
        if (pWidget instanceof GuiButtonTextToggle) {
            this.textToggleList.add((GuiButtonTextToggle)pWidget);
        }
        return (T)t;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        this.m_93228_(stack, this.guiLeft, this.guiTop, 0, 0, 176, 166);
        this.m_93228_(stack, this.guiLeft + 176, this.guiTop, 176, 0, 80, 95);
        this.m_93228_(stack, this.guiLeft - 80, this.guiTop, 176, 0, 80, 95);
        if (this.helper.hasSizeWindow()) {
            this.m_93228_(stack, this.guiLeft - 80, this.guiTop + 95 + 1, 176, 96, 80, 34);
            DrawScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)("" + this.helper.toolSize), (int)(this.guiLeft - 80 + 40), (int)(this.guiTop + 95 + 11), (int)Color.WHITE.getRGB());
        }
        this.helper.renderBackgroundBlock(stack, this.guiLeft + 6, this.guiTop + 9);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        DrawScreen.m_93172_((PoseStack)stack, (int)(this.guiLeft + 138), (int)(this.guiTop + 125), (int)(this.guiLeft + 138 + 32), (int)(this.guiTop + 125 + 32), (int)this.helper.color.getRGB());
        int offsetMouseX = this.offsetMouseX(mouseX);
        int offsetMouseY = this.offsetMouseY(mouseY);
        boolean drawSelect = this.isInPicture(offsetMouseX, offsetMouseY) && this.helper.activeDrawType() != EnumDrawType.PICK_COLOR;
        int[][] toDraw = this.helper.getBasePicture();
        if (drawSelect) {
            int pixelPosX = offsetMouseX / this.helper.currentState().scaleFactor;
            int pixelPosY = offsetMouseY / this.helper.currentState().scaleFactor;
            toDraw = MCPaintUtil.copyOf(toDraw);
            this.helper.activeDrawType().draw(toDraw, this.helper.color, pixelPosX, pixelPosY, this.helper.toolSize);
        }
        this.helper.renderImage(stack, this.guiLeft + 6, this.guiTop + 9, toDraw);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.helper.handleMouseClick(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int clickedMouseButton, double v2, double v3) {
        if (this.helper.handleMouseDragged(mouseX, mouseY, clickedMouseButton)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, clickedMouseButton, v2, v3);
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        this.helper.handleMouseReleased(mouseX, mouseY, mouseButton);
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7933_(int keyCode, int i1, int i2) {
        if (keyCode == 90 && InputConstants.m_84830_((long)this.f_96541_.m_91268_().m_85439_(), (int)341)) {
            if (InputConstants.m_84830_((long)this.f_96541_.m_91268_().m_85439_(), (int)340)) {
                this.helper.redo();
            } else {
                this.helper.undo();
            }
            return true;
        }
        return super.m_7933_(keyCode, i1, i2);
    }

    private void handleColorChange(Color color) {
        this.helper.color = color;
        this.updateSliders();
    }

    protected void handleToolButton(Button button) {
        for (GuiButtonTextToggle toggleButton : this.textToggleList) {
            boolean toggled;
            toggleButton.toggled = toggled = toggleButton == button;
            if (!toggled) continue;
            boolean hadSizeWindow = this.helper.switchToolButton(toggleButton.type);
            if (this.helper.activeDrawType().hasSizeRegulator && !hadSizeWindow) {
                this.m_142416_(this.moreSize);
                this.m_142416_(this.lessSize);
                continue;
            }
            if (this.helper.activeDrawType().hasSizeRegulator || !hadSizeWindow) continue;
            this.m_169411_((GuiEventListener)this.moreSize);
            this.m_169411_((GuiEventListener)this.lessSize);
        }
    }

    public void m_7861_() {
        this.helper.onClose();
    }

    private Slider makeSlider(int xPos, int yPos, String key) {
        return new Slider(xPos, yPos, 74, 20, (Component)new TranslatableComponent(key), TextComponent.f_131282_, 0.0, 255.0, 0.0, false, true, null, (Slider.ISlider)this);
    }

    private void handleSizeChanged() {
        if (this.helper.toolSize >= 10) {
            this.helper.toolSize = 10;
            this.moreSize.f_93623_ = false;
        } else {
            this.moreSize.f_93623_ = true;
        }
        if (this.helper.toolSize <= 1) {
            this.helper.toolSize = 1;
            this.lessSize.f_93623_ = false;
        } else {
            this.lessSize.f_93623_ = true;
        }
    }

    public void onChangeSliderValue(Slider slider) {
        if (this.updating) {
            return;
        }
        this.helper.color = new Color(this.redSlider.getValueInt(), this.greenSlider.getValueInt(), this.blueSlider.getValueInt(), this.alphaSlider.getValueInt());
    }

    @Override
    public void updateSliders() {
        Color color = this.helper.color;
        this.redSlider.setValue((double)color.getRed());
        this.blueSlider.setValue((double)color.getBlue());
        this.greenSlider.setValue((double)color.getGreen());
        this.alphaSlider.setValue((double)color.getAlpha());
        this.updating = true;
        this.redSlider.updateSlider();
        this.blueSlider.updateSlider();
        this.greenSlider.updateSlider();
        this.alphaSlider.updateSlider();
        this.updating = false;
    }

    @Override
    public void updateUndoRedoButton(boolean hasUndo, boolean hasRedo) {
        this.undo.f_93623_ = hasUndo;
        this.redo.f_93623_ = hasRedo;
    }

    @Override
    public boolean isInPicture(int offsetMouseX, int offsetMouseY) {
        PictureState currentState = this.helper.currentState();
        return offsetMouseX >= 0 && offsetMouseX < currentState.picture.length * currentState.scaleFactor && offsetMouseY >= 0 && offsetMouseY < currentState.picture.length * currentState.scaleFactor;
    }

    @Override
    public int offsetMouseX(int mouseX) {
        return mouseX - this.guiLeft - 6;
    }

    @Override
    public int offsetMouseY(int mouseY) {
        return mouseY - this.guiTop - 9;
    }

    public boolean m_7043_() {
        return false;
    }
}

