/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.client.render.OptimizedPictureRenderer;
import ichttt.mods.mcpaint.client.render.RenderTypeHandler;
import ichttt.mods.mcpaint.client.render.RenderUtil;
import ichttt.mods.mcpaint.client.render.buffer.BufferManager;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class TERCanvas
implements BlockEntityRenderer<TileEntityCanvas> {
    private static final boolean DEBUG = Boolean.getBoolean("mcpaint.tercanvas.debug");
    private static final Direction[] VALUES = Direction.values();

    public TERCanvas(BlockEntityRendererProvider.Context pContext) {
    }

    private static void renderFace(PoseStack matrix, VertexConsumer vertexBuilder, TileEntityCanvas te, Direction facing, int light, double playerDistSq) {
        boolean slow;
        boolean xOffset = false;
        boolean yOffset = false;
        boolean zOffset = false;
        int angle = 0;
        double translationXOffset = 0.0;
        double translationYOffset = 0.0;
        double translationZOffset = 0.0;
        switch (facing) {
            case NORTH: {
                angle = 0;
                zOffset = true;
                translationZOffset = 0.0015;
                break;
            }
            case EAST: {
                angle = 270;
                translationXOffset = -0.0015;
                break;
            }
            case SOUTH: {
                angle = 180;
                xOffset = true;
                translationZOffset = -0.0015;
                break;
            }
            case WEST: {
                angle = 90;
                xOffset = true;
                zOffset = true;
                translationXOffset = 0.0015;
                break;
            }
            case UP: {
                xOffset = true;
                zOffset = true;
                translationYOffset = -0.0015;
                break;
            }
            case DOWN: {
                yOffset = true;
                zOffset = true;
                translationYOffset = 0.0015;
            }
        }
        if (playerDistSq < 16.0) {
            translationXOffset /= 2.0;
            translationYOffset /= 2.0;
            translationZOffset /= 2.0;
        }
        if (playerDistSq < 36.0) {
            translationXOffset /= 4.0;
            translationYOffset /= 4.0;
            translationZOffset /= 4.0;
        }
        if (playerDistSq < 64.0) {
            translationXOffset /= 2.0;
            translationYOffset /= 2.0;
            translationZOffset /= 2.0;
        }
        if (playerDistSq > 256.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        if (playerDistSq > 1024.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        if (playerDistSq > 4096.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        if (playerDistSq > 9216.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        matrix.m_85836_();
        matrix.m_85837_(translationXOffset + (double)xOffset, translationYOffset + (double)yOffset, translationZOffset + (double)zOffset);
        if (angle != 0) {
            matrix.m_85845_(Vector3f.f_122225_.m_122240_((float)angle));
        } else if (facing.m_122434_().m_122478_()) {
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(facing == Direction.DOWN ? -90.0f : 90.0f));
            matrix.m_85845_(Vector3f.f_122227_.m_122240_(facing == Direction.UP ? 180.0f : 0.0f));
        }
        IPaintable paint = te.getPaintFor(facing);
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        boolean bl = slow = (Boolean)MCPaintConfig.CLIENT.optimizePictures.get() == false;
        if (!slow) {
            BufferManager builder = te.getBuffer(facing);
            if (builder == null) {
                int maxDistOffset = (Integer)MCPaintConfig.CLIENT.maxPaintRenderDistance.get() - 8;
                if (playerDistSq < (double)(maxDistOffset * maxDistOffset)) {
                    slow = true;
                }
            } else {
                OptimizedPictureRenderer optimizedPictureRenderer = builder.get(TERCanvas.getRes(playerDistSq));
                if (DEBUG) {
                    long tick = Minecraft.m_91087_().f_91073_.m_46467_() / 5L;
                    int idx = Math.toIntExact(tick % (long)optimizedPictureRenderer.getInstructions());
                    optimizedPictureRenderer.renderShard(matrix4f, vertexBuilder, light, idx);
                } else {
                    optimizedPictureRenderer.renderPicture(matrix4f, vertexBuilder, light);
                }
            }
        }
        if (slow) {
            RenderUtil.renderInGame(matrix4f, paint.getScaleFactor(), vertexBuilder, paint.getPictureData(true), light);
        }
        matrix.m_85849_();
    }

    public static int getRes(double playerDistSq) {
        if (playerDistSq < 1024.0) {
            return 128;
        }
        if (playerDistSq < 4096.0) {
            return 64;
        }
        if (playerDistSq < 9216.0) {
            return 32;
        }
        if (playerDistSq < 16384.0) {
            return 16;
        }
        return 8;
    }

    public void render(TileEntityCanvas te, float v, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource iRenderTypeBuffer, int light, int otherlight) {
        BlockPos pos = te.m_58899_();
        double playerDistSq = Minecraft.m_91087_().f_91074_.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        int maxDist = (Integer)MCPaintConfig.CLIENT.maxPaintRenderDistance.get();
        VertexConsumer builder = iRenderTypeBuffer.m_6299_(RenderTypeHandler.CANVAS);
        if (playerDistSq < (double)(maxDist * maxDist)) {
            for (Direction facing : VALUES) {
                if (!te.hasPaintFor(facing)) continue;
                int lightPacked = LevelRenderer.m_109537_((BlockAndTintGetter)te.m_58904_(), (BlockState)te.m_58904_().m_8055_(te.m_58899_()), (BlockPos)te.m_58899_().m_142300_(facing.m_122424_()));
                TERCanvas.renderFace(matrixStack, builder, te, facing, lightPacked, playerDistSq);
            }
        } else {
            te.unbindBuffers();
        }
    }

    public int m_142163_() {
        int distOffset = (Integer)MCPaintConfig.CLIENT.maxPaintRenderDistance.get() + 8;
        return distOffset * distOffset;
    }
}

