/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.block;

import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockCanvas
extends Block
implements EntityBlock {
    public static final BooleanProperty SOLID = BooleanProperty.m_61465_((String)"solid");
    public static final BooleanProperty NORMAL_CUBE = BooleanProperty.m_61465_((String)"normal_cube");

    public BlockCanvas(Material material, ResourceLocation regNam) {
        super(BlockBehaviour.Properties.m_60939_((Material)material).m_60913_(1.0f, 4.0f).m_60924_((state, world, pos) -> (Boolean)state.m_61143_((Property)NORMAL_CUBE)));
        this.setRegistryName(regNam);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SOLID, (Comparable)Boolean.valueOf(true))).m_61124_((Property)NORMAL_CUBE, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityCanvas(pos, state);
    }

    @Nonnull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().m_60625_(player, world, pos);
        }
        return super.m_5880_(state, player, world, pos);
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().m_60734_().getExplosionResistance(canvas.getContainedState(), world, pos, explosion);
        }
        return super.getExplosionResistance(state, world, pos, explosion);
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().m_60734_().getSoundType(canvas.getContainedState(), world, pos, entity);
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public void m_6240_(@Nonnull Level world, Player player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        if (te instanceof TileEntityCanvas && ((TileEntityCanvas)te).getContainedState() != null) {
            TileEntityCanvas canvas = (TileEntityCanvas)te;
            state = canvas.getContainedState();
            state.m_60734_().m_6240_(world, player, pos, state, te, stack);
            return;
        }
        super.m_6240_(world, player, pos, state, te, stack);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            return state.m_60734_().canHarvestBlock(state, world, pos, player);
        }
        return super.canHarvestBlock(state, world, pos, player);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().m_60742_(world, pos, context);
        }
        return super.m_5939_(state, world, pos, context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().m_60651_(world, pos, context);
        }
        return super.m_5940_(state, world, pos, context);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().m_60816_(world, pos);
        }
        return super.m_7952_(state, world, pos);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        TileEntityCanvas canvas;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileEntityCanvas && (canvas = (TileEntityCanvas)te).getContainedState() != null) {
            return canvas.getContainedState().m_60771_(world, pos, context);
        }
        return super.m_5909_(state, world, pos, context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SOLID, NORMAL_CUBE});
    }

    @Nonnull
    public ItemStack getCloneItemStack(@Nonnull BlockState state, HitResult target, @Nonnull BlockGetter world, @Nonnull BlockPos pos, Player player) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.m_7702_(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            return state.m_60734_().getCloneItemStack(canvas.getContainedState(), target, world, pos, player);
        }
        return ItemStack.f_41583_;
    }

    public SoundType m_49962_(BlockState state) {
        return super.m_49962_(state);
    }

    public BlockState getStateFrom(BlockGetter world, BlockPos pos, BlockState state) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)SOLID, (Comparable)Boolean.valueOf(state.m_60815_()))).m_61124_((Property)NORMAL_CUBE, (Comparable)Boolean.valueOf(state.m_60796_(world, pos)));
    }
}

