/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.block;

import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.client.render.batch.IOptimisationCallback;
import ichttt.mods.mcpaint.client.render.batch.RenderCache;
import ichttt.mods.mcpaint.client.render.batch.SimpleCallback;
import ichttt.mods.mcpaint.client.render.buffer.BufferManager;
import ichttt.mods.mcpaint.common.EventHandler;
import ichttt.mods.mcpaint.common.capability.CapabilityPaintable;
import ichttt.mods.mcpaint.common.capability.IPaintValidator;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.common.capability.Paint;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public class TileEntityCanvas
extends BlockEntity
implements IPaintValidator {
    public static final ModelProperty<BlockState> BLOCK_STATE_PROPERTY = new ModelProperty();
    private final Map<Direction, IPaintable> facingToPaintMap = new EnumMap<Direction, IPaintable>(Direction.class);
    private BlockState containedState;
    private final Map<Direction, Object> bufferMap = new EnumMap<Direction, Object>(Direction.class);
    private final Set<Direction> disallowedFaces = EnumSet.noneOf(Direction.class);

    public TileEntityCanvas(BlockPos pos, BlockState state) {
        super(EventHandler.CANVAS_TE, pos, state);
    }

    @Nonnull
    public void m_183515_(CompoundTag tag) {
        if (this.containedState != null) {
            tag.m_128365_("blockState", (Tag)NbtUtils.m_129202_((BlockState)this.containedState));
        }
        CompoundTag faces = new CompoundTag();
        for (Map.Entry<Direction, IPaintable> entry : this.facingToPaintMap.entrySet()) {
            faces.m_128365_(entry.getKey().m_122433_(), (Tag)CapabilityPaintable.writeToNBT(entry.getValue(), new CompoundTag()));
        }
        tag.m_128365_("faces", (Tag)faces);
        if (!this.disallowedFaces.isEmpty()) {
            CompoundTag blockedFaces = new CompoundTag();
            for (Direction facing : Direction.values()) {
                blockedFaces.m_128379_(facing.m_122433_(), this.disallowedFaces.contains(facing));
            }
            tag.m_128365_("blocked", (Tag)blockedFaces);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.containedState = tag.m_128425_("blockState", 10) ? NbtUtils.m_129241_((CompoundTag)tag.m_128469_("blockState")) : null;
        CompoundTag faces = tag.m_128469_("faces");
        for (String key : faces.m_128431_()) {
            Paint paint = new Paint(this);
            CapabilityPaintable.readFromNBT(paint, faces.m_128469_(key));
            this.facingToPaintMap.put(Direction.m_122402_((String)key), paint);
        }
        this.disallowedFaces.clear();
        if (tag.m_128441_("blocked")) {
            CompoundTag blockedFaces = tag.m_128469_("blocked");
            for (String key : blockedFaces.m_128431_()) {
                if (!blockedFaces.m_128471_(key)) continue;
                this.disallowedFaces.add(Direction.m_122402_((String)key));
            }
        }
    }

    public void handleUpdateTag(@Nonnull CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction facing) {
        if (cap == CapabilityPaintable.PAINTABLE) {
            return LazyOptional.of(() -> this.getPaintFor(facing));
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public boolean isValidPixelCount(short pixelCountX, short pixelCountY) {
        return pixelCountX == 0 && pixelCountY == 0 || pixelCountX == 128 && pixelCountY == 128;
    }

    public void setInitialData(BlockState state, Set<Direction> disallowedFaces) {
        this.containedState = state;
        this.disallowedFaces.addAll(disallowedFaces);
        this.m_6596_();
        if (this.f_58857_.f_46443_) {
            ModelDataManager.requestModelDataRefresh((BlockEntity)this);
        }
    }

    public BlockState getContainedState() {
        return this.containedState;
    }

    public IPaintable getPaintFor(Direction facing) {
        return this.facingToPaintMap.computeIfAbsent(facing, face -> new Paint(this));
    }

    public boolean hasPaintFor(Direction facing) {
        IPaintable paint = this.facingToPaintMap.get(facing);
        if (paint == null) {
            return false;
        }
        return paint.hasPaintData();
    }

    @OnlyIn(value=Dist.CLIENT)
    public BufferManager getBuffer(final Direction facing) {
        Object obj = this.bufferMap.get(facing);
        if (obj instanceof BufferManager) {
            return (BufferManager)obj;
        }
        if (obj instanceof IOptimisationCallback) {
            return null;
        }
        if (obj != null) {
            MCPaint.LOGGER.error("Unknown object " + obj);
            return null;
        }
        SimpleCallback callback = new SimpleCallback(){

            @Override
            public void provideFinishedBuffer(BufferManager builder) {
                if (this.isInvalid()) {
                    return;
                }
                RenderCache.cache(TileEntityCanvas.this.getPaintFor(facing), builder);
                TileEntityCanvas.this.bufferMap.put(facing, builder);
            }
        };
        this.bufferMap.put(facing, callback);
        RenderCache.getOrRequest(this.facingToPaintMap.get(facing), callback);
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void unbindBuffers() {
        for (Map.Entry<Direction, Object> entry : this.bufferMap.entrySet()) {
            Object obj = entry.getValue();
            if (obj instanceof SimpleCallback) {
                ((SimpleCallback)obj).invalidate();
                continue;
            }
            if (!(obj instanceof BufferManager)) continue;
            RenderCache.cache(this.getPaintFor(entry.getKey()), (BufferManager)obj);
        }
        this.bufferMap.clear();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        this.unbindBuffers();
    }

    public void invalidateBuffer(Direction facing) {
        Object obj = this.bufferMap.remove(facing);
        if (obj instanceof SimpleCallback) {
            ((SimpleCallback)obj).invalidate();
        } else if (obj instanceof BufferManager) {
            RenderCache.uncache(this.getPaintFor(facing));
        } else if (obj != null) {
            MCPaint.LOGGER.warn("Unknown obj " + obj);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            this.unbindBuffers();
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(BLOCK_STATE_PROPERTY, (Object)this.containedState).build();
    }

    public boolean isSideBlockedForPaint(Direction facing) {
        return this.disallowedFaces.contains(facing);
    }

    public void removePaint(Direction facing) {
        this.facingToPaintMap.remove(facing);
    }
}

