/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.capability;

import ichttt.mods.mcpaint.common.MCPaintUtil;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.common.capability.Paint;
import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class CapabilityPaintable {
    public static Capability<IPaintable> PAINTABLE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPaintable>(){});

    public static void register() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(CapabilityPaintable::onRegisterCapabilities);
    }

    private static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(Paint.class);
    }

    public static CompoundTag writeToNBT(IPaintable instance, CompoundTag compound) {
        if (instance.hasPaintData()) {
            short pixelCountX = instance.getPixelCountX();
            byte scaleFactor = instance.getScaleFactor();
            int[][] pictureData = instance.getPictureData(true);
            compound.m_128376_("pixelX", pixelCountX);
            compound.m_128344_("scale", scaleFactor);
            int[] palette = instance.getPalette();
            Int2ByteMap reversePalette = null;
            if (palette != null) {
                compound.m_128385_("palette", palette);
                reversePalette = MCPaintUtil.buildReversePalette(palette);
            }
            ListTag listTag = new ListTag();
            for (int i = 0; i < pixelCountX / scaleFactor; ++i) {
                int[] row = pictureData[i];
                if (palette == null) {
                    listTag.add((Object)new IntArrayTag(row));
                    continue;
                }
                byte[] asByteDat = new byte[row.length];
                for (int j = 0; j < row.length; ++j) {
                    asByteDat[j] = reversePalette.get(row[j]);
                }
                listTag.add((Object)new ByteArrayTag(asByteDat));
            }
            compound.m_128365_("picture", (Tag)listTag);
            return compound;
        }
        return compound;
    }

    public static void readFromNBT(IPaintable instance, CompoundTag compound) {
        if (!compound.m_128441_("scale")) {
            return;
        }
        short pixelCountX = compound.m_128448_("pixelX");
        byte scaleFactor = compound.m_128445_("scale");
        if (compound.m_128425_("picture", 10)) {
            CompoundTag pictureInfo = compound.m_128469_("picture");
            int arraySize = pixelCountX / scaleFactor;
            int[][] pictureData = new int[arraySize][];
            for (int i = 0; i < arraySize; ++i) {
                pictureData[i] = pictureInfo.m_128465_("" + i);
            }
            instance.setData(scaleFactor, pictureData, null, null);
        } else {
            int[] palette = compound.m_128425_("palette", 11) ? compound.m_128465_("palette") : null;
            ListTag pictureInfo = compound.m_128437_("picture", palette == null ? 11 : 7);
            int arraySize = pixelCountX / scaleFactor;
            int[][] pictureData = new int[arraySize][];
            for (int i = 0; i < arraySize; ++i) {
                if (palette == null) {
                    pictureData[i] = pictureInfo.m_128767_(i);
                    continue;
                }
                byte[] data = ((ByteArrayTag)pictureInfo.get(i)).m_128227_();
                int[] row = new int[data.length];
                for (int j = 0; j < data.length; ++j) {
                    row[j] = palette[data[j]];
                }
                pictureData[i] = row;
            }
            instance.setDataWithPalette(scaleFactor, pictureData, palette, null, null);
        }
    }
}

