/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.item;

import ichttt.mods.mcpaint.client.ClientHooks;
import ichttt.mods.mcpaint.client.render.ISTERStamp;
import ichttt.mods.mcpaint.common.EventHandler;
import ichttt.mods.mcpaint.common.block.BlockCanvas;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.fml.DistExecutor;

public class ItemBrush
extends Item {
    public static Item.Properties getProperties() {
        Item.Properties properties = new Item.Properties();
        properties.m_41491_(CreativeModeTab.f_40750_).m_41487_(1).m_41499_(32);
        return properties;
    }

    public ItemBrush(ResourceLocation registryName) {
        super(ItemBrush.getProperties());
        this.setRegistryName(registryName);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return ISTERStamp.INSTANCE;
            }
        });
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        BlockHitResult raytraceresult = ItemBrush.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (raytraceresult.m_6662_() != HitResult.Type.BLOCK) {
            return new InteractionResultHolder(this.processMiss(world, player, hand, held, (HitResult)raytraceresult), (Object)held);
        }
        BlockHitResult blockRayTraceResult = raytraceresult;
        BlockPos pos = blockRayTraceResult.m_82425_();
        BlockState state = world.m_8055_(pos);
        Direction facing = blockRayTraceResult.m_82434_();
        return new InteractionResultHolder(this.processHit(world, player, hand, pos, state, facing), (Object)held);
    }

    protected InteractionResult processMiss(Level world, Player player, InteractionHand hand, ItemStack stack, @Nullable HitResult result) {
        return InteractionResult.FAIL;
    }

    protected InteractionResult processHit(Level world, Player player, InteractionHand hand, BlockPos pos, BlockState state, Direction facing) {
        if (state.m_60734_() instanceof BlockCanvas) {
            TileEntityCanvas canvas = (TileEntityCanvas)Objects.requireNonNull(world.m_7702_(pos));
            if (canvas.isSideBlockedForPaint(facing)) {
                return InteractionResult.FAIL;
            }
            ItemStack held = player.m_21120_(hand);
            this.startPainting(canvas, world, held, pos, facing.m_122424_(), state);
            held.m_41622_(1, (LivingEntity)player, p_220282_1_ -> p_220282_1_.m_21190_(hand));
            return InteractionResult.SUCCESS;
        }
        if (Block.m_49863_((LevelReader)world, (BlockPos)pos, (Direction)facing) && state.m_60767_().m_76337_() && state.m_60799_() == RenderShape.MODEL && !(state.m_60734_() instanceof EntityBlock)) {
            EnumSet<Direction> disallowedFaces = EnumSet.noneOf(Direction.class);
            for (Direction testFacing : Direction.values()) {
                if (Block.m_49863_((LevelReader)world, (BlockPos)pos, (Direction)testFacing)) continue;
                disallowedFaces.add(testFacing);
            }
            if (state.m_60767_().m_76335_()) {
                world.m_46597_(pos, EventHandler.CANVAS_WOOD.getStateFrom((BlockGetter)world, pos, state));
            } else if (!state.m_60834_()) {
                world.m_46597_(pos, EventHandler.CANVAS_GROUND.getStateFrom((BlockGetter)world, pos, state));
            } else {
                world.m_46597_(pos, EventHandler.CANVAS_ROCK.getStateFrom((BlockGetter)world, pos, state));
            }
            TileEntityCanvas canvas = (TileEntityCanvas)Objects.requireNonNull(world.m_7702_(pos));
            canvas.setInitialData(state, disallowedFaces);
            canvas.m_6596_();
            ItemStack held = player.m_21120_(hand);
            this.startPainting(canvas, world, held, pos, facing.m_122424_(), state);
            held.m_41622_(1, (LivingEntity)player, p_220282_1_ -> p_220282_1_.m_21190_(hand));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected void startPainting(TileEntityCanvas canvas, Level world, ItemStack heldItem, BlockPos pos, Direction facing, BlockState state) {
        if (world.f_46443_) {
            if (canvas.hasPaintFor(facing)) {
                ArrayList<IPaintable> list = new ArrayList<IPaintable>(1);
                list.add(canvas.getPaintFor(facing));
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHooks.showGuiDraw(list, canvas.m_58899_(), facing, canvas.getContainedState()));
            } else {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHooks.showGuiDraw(pos, facing, canvas.getContainedState()));
            }
        }
    }
}

