/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.LightTexture;

public class RenderUtil {
    public static void renderInGui(Matrix4f matrix4f, float leftOffset, float topOffset, byte scaleFactor, BufferBuilder builder, int[][] picture) {
        int light = LightTexture.m_109885_((int)15, (int)15);
        for (int x = 0; x < picture.length; ++x) {
            int[] yPos = picture[x];
            for (int y = 0; y < yPos.length; ++y) {
                int color = picture[x][y];
                float left = leftOffset + (float)(x * scaleFactor);
                float top = topOffset + (float)(y * scaleFactor);
                float right = left + (float)scaleFactor;
                float bottom = top + (float)scaleFactor;
                RenderUtil.drawToBuffer(matrix4f, color, (VertexConsumer)builder, left, top, right, bottom, light);
            }
        }
    }

    public static void renderInGame(Matrix4f matrix4f, byte scaleFactor, VertexConsumer builder, int[][] picture, int light) {
        for (int x = 0; x < picture.length; ++x) {
            int[] yPos = picture[x];
            for (int y = 0; y < yPos.length; ++y) {
                int color = picture[x][y];
                float left = (float)(x * scaleFactor) / 128.0f + (float)scaleFactor / 128.0f;
                float top = 1.0f - (float)(y * scaleFactor) / 128.0f - (float)scaleFactor / 128.0f;
                float right = left - (float)scaleFactor / 128.0f;
                float bottom = top + (float)scaleFactor / 128.0f;
                RenderUtil.drawToBuffer(matrix4f, color, builder, left, top, right, bottom, light);
            }
        }
    }

    public static boolean drawToBuffer(Matrix4f matrix4f, int color, VertexConsumer builder, float left, float top, float right, float bottom, int light) {
        int a = color >> 24 & 0xFF;
        if (a <= 2) {
            return true;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.m_85982_(matrix4f, left, bottom, 0.0f).m_6122_(r, g, b, a).m_85969_(light).m_5752_();
        builder.m_85982_(matrix4f, right, bottom, 0.0f).m_6122_(r, g, b, a).m_85969_(light).m_5752_();
        builder.m_85982_(matrix4f, right, top, 0.0f).m_6122_(r, g, b, a).m_85969_(light).m_5752_();
        builder.m_85982_(matrix4f, left, top, 0.0f).m_6122_(r, g, b, a).m_85969_(light).m_5752_();
        return false;
    }
}

