/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.networking;

import ichttt.mods.mcpaint.networking.MessagePaintData;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class MessageClearSide {
    private final BlockPos pos;
    private final Direction facing;

    public MessageClearSide(FriendlyByteBuf buffer) {
        this(buffer.m_130135_(), Direction.m_122376_((int)buffer.readByte()));
    }

    public MessageClearSide(BlockPos pos, Direction facing) {
        this.pos = pos;
        this.facing = facing;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeByte(this.facing.m_122411_());
    }

    public static class ClientMessage
    extends MessageClearSide {
        public ClientMessage(FriendlyByteBuf buffer) {
            super(buffer);
        }

        public ClientMessage(BlockPos pos, Direction facing) {
            super(pos, facing);
        }
    }

    public static class ClientHandler {
        public static void onMessage(MessageClearSide message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context context = supplier.get();
            context.enqueueWork(() -> MessagePaintData.ClientHandler.INSTANCE.handleSide(context, message.pos, message.facing, (byte)0, null, null));
            context.setPacketHandled(true);
        }
    }

    public static class ServerHandler {
        public static void onMessage(MessageClearSide message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context context = supplier.get();
            context.enqueueWork(() -> MessagePaintData.ServerHandler.INSTANCE.handleSide(context, message.pos, message.facing, (byte)0, null, null));
            context.setPacketHandled(true);
        }
    }
}

