/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;
import qouteall.mini_scaled.MiniScaledPortal;
import qouteall.mini_scaled.ScaleBoxCraftingRecipe;
import qouteall.mini_scaled.ScaleBoxEntranceItem;
import qouteall.mini_scaled.ScaleBoxGeneration;
import qouteall.mini_scaled.VoidDimension;
import qouteall.mini_scaled.block.BoxBarrierBlock;
import qouteall.mini_scaled.block.ScaleBoxPlaceholderBlock;
import qouteall.mini_scaled.block.ScaleBoxPlaceholderBlockEntity;
import qouteall.q_misc_util.api.DimensionAPI;

public class MiniScaledModInitializer
implements ModInitializer {
    public void onInitialize() {
        DimensionAPI.serverDimensionsLoadEvent.register(VoidDimension::initializeVoidDimension);
        ScaleBoxPlaceholderBlock.init();
        BoxBarrierBlock.init();
        ScaleBoxPlaceholderBlockEntity.init();
        MiniScaledPortal.init();
        ScaleBoxEntranceItem.init();
        ScaleBoxCraftingRecipe.init();
        IPGlobal.enableDepthClampForPortalRendering = true;
        ServerTickEvents.END_SERVER_TICK.register(MiniScaledModInitializer::teleportFallenEntities);
        System.out.println("MiniScaled Mod Initializing");
    }

    private static void teleportFallenEntities(MinecraftServer server) {
        server.method_16044().method_15396("mini_scaled_tick");
        class_3218 voidWorld = server.method_3847(VoidDimension.dimensionId);
        if (voidWorld != null) {
            for (class_1297 entity : voidWorld.method_27909()) {
                MiniScaledModInitializer.teleportFallenEntity(entity);
            }
        }
        server.method_16044().method_15407();
    }

    private static void teleportFallenEntity(class_1297 entity) {
        if (entity.method_23318() < 32.0) {
            System.out.println("Entity fallen from scale box " + entity);
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                class_3218 overworld = player.field_13995.method_3847(class_1937.field_25179);
                ServerTeleportationManager.teleportEntityGeneral((class_1297)player, (class_243)class_243.method_24953((class_2382)overworld.method_27911()), (class_3218)overworld);
                IPGlobal.serverTaskList.addTask(() -> {
                    player.method_7353((class_2561)new class_2585("You fell off the scale box. Returned to the spawn point"), false);
                    return true;
                });
            } else {
                class_2338 blockPos = entity.method_24515();
                class_2338 newPos = ScaleBoxGeneration.getNearestPosInScaleBoxToTeleportTo(blockPos);
                entity.method_18799(class_243.field_1353);
                ServerTeleportationManager.teleportEntityGeneral((class_1297)entity, (class_243)class_243.method_24953((class_2382)newPos), (class_3218)((class_3218)entity.field_6002));
            }
        }
    }
}

