/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_746;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.mini_scaled.ScaleBoxRecord;

public class MiniScaledPortal
extends Portal {
    public static class_1299<MiniScaledPortal> entityType;
    public int boxId = 0;
    public int generation = 0;
    private static boolean messageShown;

    public MiniScaledPortal(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6002.method_8608()) {
            this.tickClient();
        } else if (this.field_6002.method_8510() % 2L == 0L) {
            this.field_6002.method_16107().method_15396("validate");
            this.checkValidity();
            this.field_6002.method_16107().method_15407();
        }
    }

    protected void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.generation = compoundTag.method_10550("generation");
        this.boxId = compoundTag.method_10550("boxId");
    }

    protected void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10569("generation", this.generation);
        compoundTag.method_10569("boxId", this.boxId);
    }

    private static <T extends class_1297> void registerEntity(Consumer<class_1299<T>> setEntityType, Supplier<class_1299<T>> getEntityType, String id, class_1299.class_4049<T> constructor, class_2378<class_1299<?>> registry) {
        class_1299 entityType = FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, constructor).dimensions(new class_4048(1.0f, 1.0f, true)).fireImmune().trackable(96, 20).build();
        setEntityType.accept(entityType);
        class_2378.method_10230((class_2378)class_2378.field_11145, (class_2960)new class_2960(id), (Object)entityType);
    }

    public static void init() {
        MiniScaledPortal.registerEntity(t -> {
            entityType = t;
        }, () -> entityType, "mini_scaled:portal", MiniScaledPortal::new, class_2378.field_11145);
    }

    private void checkValidity() {
        ScaleBoxRecord.Entry entry = ScaleBoxRecord.getEntryById(this.boxId);
        if (entry == null) {
            System.err.println("no scale box record " + this.boxId + this);
            this.method_5650(class_1297.class_5529.field_26998);
            return;
        }
        if (this.generation != entry.generation) {
            System.out.println("removing old portal " + this);
            this.method_5650(class_1297.class_5529.field_26998);
            return;
        }
    }

    public boolean isOuterPortal() {
        return this.getScale() > 1.0;
    }

    public double getDestAreaRadiusEstimation() {
        return 192.0;
    }

    public boolean allowOverlappedTeleport() {
        return true;
    }

    public void onCollidingWithEntity(class_1297 entity) {
        if (this.field_6002.method_8608()) {
            this.onCollidingWithEntityClientOnly(entity);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void onCollidingWithEntityClientOnly(class_1297 entity) {
        if (this.isOuterPortal() && this.getNormal().field_1351 > 0.9 && entity instanceof class_746) {
            this.showShiftDescendMessage();
            class_1657 player = (class_1657)entity;
            if (player.method_18376() == class_4050.field_18081) {
                IPGlobal.clientTaskList.addTask(() -> {
                    if (player.field_6002 == this.field_6002) {
                        player.method_23327(player.method_23317(), player.method_23318() - 0.01, player.method_23321());
                        McHelper.updateBoundingBox((class_1297)player);
                    }
                    return true;
                });
            }
            class_243 velocity = entity.method_18798();
            if (velocity.field_1351 < 0.0 && player.method_23318() < this.method_23318()) {
                entity.method_18799(new class_243(velocity.field_1352, velocity.field_1351 * 0.4, velocity.field_1350));
            }
        }
    }

    public void transformVelocity(class_1297 entity) {
        super.transformVelocity(entity);
        if (this.isOuterPortal() && this.getNormal().field_1351 > 0.9) {
            entity.method_18799(entity.method_18798().method_1021(0.5));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void tickClient() {
    }

    @Environment(value=EnvType.CLIENT)
    private void showShiftDescendMessage() {
        if (messageShown) {
            return;
        }
        messageShown = true;
        class_310 client = class_310.method_1551();
        client.field_1705.method_1758((class_2561)new class_2588("mini_scaled.press_shift", new Object[]{client.field_1690.field_1832.method_16007()}), false);
    }

    static {
        messageShown = false;
    }
}

