/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import qouteall.mini_scaled.ScaleBoxGeneration;
import qouteall.mini_scaled.ScaleBoxRecord;

public class ScaleBoxEntranceItem
extends class_1792 {
    public static final ScaleBoxEntranceItem instance = new ScaleBoxEntranceItem(new class_1792.class_1793().method_7892(class_1761.field_7932));
    private static final class_2561 spaceText = new class_2585(" ");

    public static void init() {
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960("mini_scaled:scale_box_item"), (Object)((Object)instance));
    }

    public ScaleBoxEntranceItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        if (world.method_8608()) {
            return class_1269.field_5814;
        }
        if (context.method_8036() == null) {
            return class_1269.field_5814;
        }
        class_2338 pos = context.method_8037().method_10093(context.method_8038());
        if (!world.method_22347(pos)) {
            return class_1269.field_5814;
        }
        class_1799 stack = context.method_8041();
        ItemInfo itemInfo = new ItemInfo(stack.method_7948());
        class_3222 player = (class_3222)context.method_8036();
        int size = itemInfo.size;
        if (!ScaleBoxGeneration.isValidSize(size)) {
            player.method_7353((class_2561)new class_2585("bad item data"), false);
            return class_1269.field_5814;
        }
        ScaleBoxGeneration.putScaleBox((class_3218)world, player, size, pos, itemInfo.color);
        stack.method_7934(1);
        return class_1269.field_5812;
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        ItemInfo itemInfo = new ItemInfo(stack.method_7948());
        tooltip.add((class_2561)new class_2588("mini_scaled.color").method_10852((class_2561)ScaleBoxEntranceItem.getColorText(itemInfo.color).method_27692(class_124.field_1065)));
        tooltip.add((class_2561)new class_2588("mini_scaled.size").method_10852((class_2561)new class_2585(Integer.toString(itemInfo.size)).method_27692(class_124.field_1075)));
        if (itemInfo.ownerNameCache != null) {
            tooltip.add((class_2561)new class_2588("mini_scaled.owner").method_10852((class_2561)new class_2585(itemInfo.ownerNameCache).method_27692(class_124.field_1054)));
        }
    }

    public void method_7850(class_1761 group, class_2371<class_1799> stacks) {
        if (this.method_7877(group)) {
            for (int size : ScaleBoxGeneration.supportedSizes) {
                for (class_1767 dyeColor : class_1767.values()) {
                    class_1799 itemStack = new class_1799((class_1935)instance);
                    ItemInfo itemInfo = new ItemInfo(size, dyeColor);
                    itemInfo.writeToTag(itemStack.method_7948());
                    stacks.add((Object)itemStack);
                }
            }
        }
    }

    public class_2561 method_7864(class_1799 stack) {
        ItemInfo itemInfo = new ItemInfo(stack.method_7948());
        class_1767 color = itemInfo.color;
        class_5250 result = new class_2588("item.mini_scaled.scale_box_item").method_10852(spaceText).method_10852((class_2561)new class_2585(Integer.toString(itemInfo.size))).method_10852(spaceText).method_10852((class_2561)ScaleBoxEntranceItem.getColorText(color));
        if (itemInfo.ownerNameCache != null) {
            result = result.method_10852(spaceText).method_10852((class_2561)new class_2588("mini_scaled.owner")).method_10852((class_2561)new class_2585(itemInfo.ownerNameCache));
        }
        return result;
    }

    public static class_2588 getColorText(class_1767 color) {
        return new class_2588("color.minecraft." + color.method_7792());
    }

    public static class_1799 boxIdToItem(int boxId) {
        ScaleBoxRecord.Entry entry = ScaleBoxRecord.getEntryById(boxId);
        if (entry == null) {
            System.err.println("invalid boxId for item " + boxId);
            return null;
        }
        class_1799 itemStack = new class_1799((class_1935)instance);
        new ItemInfo(entry.size, entry.color, entry.ownerId, entry.ownerNameCache).writeToTag(itemStack.method_7948());
        return itemStack;
    }

    public static int getRenderingColor(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return 0;
        }
        String colorText = nbt.method_10558("color");
        class_1767 dyeColor = class_1767.method_7793((String)colorText, (class_1767)class_1767.field_7963);
        return dyeColor.method_7794().field_16011;
    }

    public static class ItemInfo {
        public int size;
        public class_1767 color;
        public UUID ownerId;
        public String ownerNameCache;

        public ItemInfo(int size, class_1767 color) {
            this.size = size;
            this.color = color;
        }

        public ItemInfo(int size, class_1767 color, UUID ownerId, String ownerNameCache) {
            this.size = size;
            this.color = color;
            this.ownerId = ownerId;
            this.ownerNameCache = ownerNameCache;
        }

        public ItemInfo(class_2487 tag) {
            this.size = tag.method_10550("size");
            this.color = class_1767.method_7793((String)tag.method_10558("color"), (class_1767)class_1767.field_7963);
            if (tag.method_10545("ownerId")) {
                this.ownerId = tag.method_25926("ownerId");
                this.ownerNameCache = tag.method_10558("ownerNameCache");
            }
        }

        public void writeToTag(class_2487 compoundTag) {
            compoundTag.method_10569("size", this.size);
            compoundTag.method_10582("color", this.color.method_7792());
            if (this.ownerId != null) {
                compoundTag.method_25927("ownerId", this.ownerId);
                compoundTag.method_10582("ownerNameCache", this.ownerNameCache);
            }
        }
    }
}

