/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled;

import java.util.Arrays;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.mini_scaled.MiniScaledPortal;
import qouteall.mini_scaled.ScaleBoxRecord;
import qouteall.mini_scaled.VoidDimension;
import qouteall.mini_scaled.block.BoxBarrierBlock;
import qouteall.mini_scaled.block.ScaleBoxPlaceholderBlock;
import qouteall.mini_scaled.block.ScaleBoxPlaceholderBlockEntity;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

public class ScaleBoxGeneration {
    static final int[] supportedSizes = new int[]{8, 16, 32};

    public static void putScaleBox(class_3218 world, class_3222 player, int size, class_2338 outerBoxPos, class_1767 color) {
        ScaleBoxRecord record = ScaleBoxRecord.get();
        ScaleBoxRecord.Entry entry = ScaleBoxGeneration.getOrCreateEntry(player, size, color, record);
        entry.currentEntranceDim = world.method_27983();
        entry.currentEntrancePos = outerBoxPos;
        ++entry.generation;
        record.method_78(true);
        class_3218 voidWorld = VoidDimension.getVoidWorld();
        ScaleBoxGeneration.createScaleBoxPortals(voidWorld, entry.getAreaBox().toRealNumberBox(), world, class_243.method_24955((class_2382)outerBoxPos), entry.size, entry.id, entry.generation);
        world.method_8501(outerBoxPos, ScaleBoxPlaceholderBlock.instance.method_9564());
        class_2586 blockEntity = world.method_8321(outerBoxPos);
        if (blockEntity == null) {
            System.err.println("cannot find block entity for scale box");
        } else {
            ScaleBoxPlaceholderBlockEntity be = (ScaleBoxPlaceholderBlockEntity)blockEntity;
            be.boxId = entry.id;
        }
    }

    private static void removeScaleBox(int boxId) {
        ScaleBoxRecord.Entry entry = ScaleBoxRecord.getEntryById(boxId);
        if (entry == null) {
            System.err.println("removing nonexistent box " + boxId);
            return;
        }
    }

    private static void createScaleBoxPortals(class_3218 areaWorld, class_238 area, class_3218 boxWorld, class_243 boxBottomCenter, double scale, int boxId, int generation) {
        class_243 viewBoxSize = Helper.getBoxSize((class_238)area).method_1021(1.0 / scale);
        class_238 viewBox = Helper.getBoxByBottomPosAndSize((class_243)boxBottomCenter, (class_243)viewBoxSize);
        for (class_2350 direction : class_2350.values()) {
            MiniScaledPortal portal = (MiniScaledPortal)PortalManipulation.createOrthodoxPortal(MiniScaledPortal.entityType, (class_3218)boxWorld, (class_3218)areaWorld, (class_2350)direction, (class_238)Helper.getBoxSurface((class_238)viewBox, (class_2350)direction), (class_243)Helper.getBoxSurface((class_238)area, (class_2350)direction).method_1005());
            portal.scaling = scale;
            portal.teleportChangesScale = false;
            portal.fuseView = true;
            portal.renderingMergable = true;
            portal.hasCrossPortalCollision = true;
            portal.portalTag = "mini_scaled:scaled_box";
            PortalExtension.get((Portal)portal).adjustPositionAfterTeleport = false;
            portal.setInteractable(false);
            portal.boxId = boxId;
            portal.generation = generation;
            McHelper.spawnServerEntity((class_1297)portal);
            MiniScaledPortal reversePortal = (MiniScaledPortal)PortalManipulation.createReversePortal((Portal)portal, MiniScaledPortal.entityType);
            reversePortal.fuseView = false;
            reversePortal.renderingMergable = true;
            reversePortal.hasCrossPortalCollision = true;
            if (direction != class_2350.field_11033 && direction != class_2350.field_11036) {
                PortalExtension.get((Portal)reversePortal).adjustPositionAfterTeleport = true;
            }
            reversePortal.setInteractable(false);
            reversePortal.boxId = boxId;
            reversePortal.generation = generation;
            McHelper.spawnServerEntity((class_1297)reversePortal);
        }
    }

    private static ScaleBoxRecord.Entry getOrCreateEntry(class_3222 player, int size, class_1767 color, ScaleBoxRecord record) {
        ScaleBoxRecord.Entry entry = record.entries.stream().filter(e -> e.ownerId.equals(player.method_5667()) && e.color == color && e.size == size).findFirst().orElse(null);
        if (entry == null) {
            int newId = ScaleBoxGeneration.allocateId(record);
            ScaleBoxRecord.Entry newEntry = new ScaleBoxRecord.Entry();
            newEntry.id = newId;
            newEntry.color = color;
            newEntry.ownerId = player.method_5667();
            newEntry.ownerNameCache = player.method_5477().method_10851();
            newEntry.size = size;
            newEntry.generation = 0;
            newEntry.innerBoxPos = ScaleBoxGeneration.allocateInnerBoxPos(newId);
            record.entries.add(newEntry);
            record.method_78(true);
            ScaleBoxGeneration.initializeInnerBoxBlocks(newEntry);
            entry = newEntry;
        }
        return entry;
    }

    private static int allocateId(ScaleBoxRecord record) {
        return record.entries.stream().mapToInt(e -> e.id).max().orElse(0) + 1;
    }

    private static class_2338 allocateInnerBoxPos(int boxId) {
        int xIndex = boxId % 265;
        int zIndex = class_3532.method_15346((int)boxId, (int)256);
        return new class_2338(xIndex * 16 * 32, 64, zIndex * 16 * 32);
    }

    public static class_2338 getNearestPosInScaleBoxToTeleportTo(class_2338 pos) {
        double gridLen = 512.0;
        return new class_2338((double)Math.round((double)pos.method_10263() / gridLen) * gridLen + 5.0, 69.0, (double)Math.round((double)pos.method_10260() / gridLen) * gridLen + 5.0);
    }

    private static class_2338 selectCoordinateFromBox(IntBox box, boolean high) {
        return high ? box.h : box.l;
    }

    private static class_2338 selectCoordinateFromBox(IntBox box, boolean xUp, boolean yUp, boolean zUp) {
        return new class_2338(ScaleBoxGeneration.selectCoordinateFromBox(box, xUp).method_10263(), ScaleBoxGeneration.selectCoordinateFromBox(box, yUp).method_10264(), ScaleBoxGeneration.selectCoordinateFromBox(box, zUp).method_10260());
    }

    private static IntBox[] get12Edges(IntBox box) {
        return new IntBox[]{new IntBox(ScaleBoxGeneration.selectCoordinateFromBox(box, false, false, false), ScaleBoxGeneration.selectCoordinateFromBox(box, false, false, true)), new IntBox(ScaleBoxGeneration.selectCoordinateFromBox(box, false, true, false), ScaleBoxGeneration.selectCoordinateFromBox(box, false, true, true)), new IntBox(ScaleBoxGeneration.selectCoordinateFromBox(box, true, false, false), ScaleBoxGeneration.selectCoordinateFromBox(box, true, false, true)), new IntBox(ScaleBoxGeneration.selectCoordinateFromBox(box, true, true, false), ScaleBoxGeneration.selectCoordinateFromBox(box, true, true, true)), new IntBox(ScaleBoxGeneration.selectCoordinateFromBox(box, false, false, false), ScaleBoxGeneration.selectCoordinateFromBox(box, false, true, false)), new IntBox(ScaleBoxGeneration.selectCoordinateFromBox(box, false, false, true), ScaleBoxGeneration.selectCoordinateFromBox(box, false, true, true)), new IntBox(ScaleBoxGeneration.selectCoordinateFromBox(box, true, false, false), ScaleBoxGeneration.selectCoordinateFromBox(box, true, true, false)), new IntBox(ScaleBoxGeneration.selectCoordinateFromBox(box, true, false, true), ScaleBoxGeneration.selectCoordinateFromBox(box, true, true, true)), new IntBox(ScaleBoxGeneration.selectCoordinateFromBox(box, false, false, false), ScaleBoxGeneration.selectCoordinateFromBox(box, true, false, false)), new IntBox(ScaleBoxGeneration.selectCoordinateFromBox(box, false, false, true), ScaleBoxGeneration.selectCoordinateFromBox(box, true, false, true)), new IntBox(ScaleBoxGeneration.selectCoordinateFromBox(box, false, true, false), ScaleBoxGeneration.selectCoordinateFromBox(box, true, true, false)), new IntBox(ScaleBoxGeneration.selectCoordinateFromBox(box, false, true, true), ScaleBoxGeneration.selectCoordinateFromBox(box, true, true, true))};
    }

    private static void initializeInnerBoxBlocks(ScaleBoxRecord.Entry entry) {
        class_3218 voidWorld = VoidDimension.getVoidWorld();
        IntBox box = entry.getAreaBox();
        ChunkLoader chunkLoader = new ChunkLoader(new DimensionalChunkPos(voidWorld.method_27983(), new class_1923(box.l)), 2);
        chunkLoader.loadChunksAndDo(() -> {
            IntBox expanded = box.getAdjusted(-1, -1, -1, 1, 1, 1);
            for (class_2350 direction : class_2350.values()) {
                expanded.getSurfaceLayer(direction).fastStream().forEach(blockPos -> voidWorld.method_8501(blockPos, BoxBarrierBlock.instance.method_9564()));
            }
            class_2248 woolBlock = (class_2248)class_2378.field_11146.method_10223(new class_2960("minecraft:" + entry.color.method_7792() + "_wool"));
            class_2680 frameBlock = woolBlock.method_9564();
            for (IntBox edge : ScaleBoxGeneration.get12Edges(box)) {
                edge.fastStream().forEach(blockPos -> voidWorld.method_8501(blockPos, frameBlock));
            }
        });
    }

    public static boolean isValidSize(int size) {
        return Arrays.stream(supportedSizes).anyMatch(s -> s == size);
    }
}

