/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1767;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.IntBox;

public class ScaleBoxRecord
extends class_18 {
    public List<Entry> entries = new ArrayList<Entry>();

    public static ScaleBoxRecord get() {
        class_3218 overworld = MiscHelper.getServer().method_30002();
        return (ScaleBoxRecord)overworld.method_17983().method_17924(nbt -> {
            ScaleBoxRecord record = new ScaleBoxRecord();
            record.readFromNbt((class_2487)nbt);
            return record;
        }, () -> {
            Helper.log((Object)"Scale box record initialized ");
            return new ScaleBoxRecord();
        }, "scale_box_record");
    }

    public static Entry getEntryById(int boxId) {
        ScaleBoxRecord scaleBoxRecord = ScaleBoxRecord.get();
        Entry entry = scaleBoxRecord.entries.stream().filter(e -> e.id == boxId).findFirst().orElse(null);
        return entry;
    }

    private void readFromNbt(class_2487 compoundTag) {
        class_2499 list = compoundTag.method_10554("entries", (int)compoundTag.method_10711());
        this.entries = list.stream().map(tag -> {
            Entry entry = new Entry();
            entry.readFromNbt((class_2487)tag);
            return entry;
        }).collect(Collectors.toList());
    }

    private void writeToNbt(class_2487 compoundTag) {
        class_2499 listTag = new class_2499();
        for (Entry entry : this.entries) {
            class_2487 tag = new class_2487();
            entry.writeToNbt(tag);
            listTag.add((Object)tag);
        }
        compoundTag.method_10566("entries", (class_2520)listTag);
    }

    public void fromTag(class_2487 tag) {
        this.readFromNbt(tag);
    }

    public class_2487 method_75(class_2487 tag) {
        this.writeToNbt(tag);
        return tag;
    }

    public static class Entry {
        public int id;
        public class_2338 innerBoxPos;
        public int size;
        public class_1767 color;
        public UUID ownerId;
        public String ownerNameCache;
        public class_5321<class_1937> currentEntranceDim;
        public class_2338 currentEntrancePos;
        public int generation;

        IntBox getAreaBox() {
            return IntBox.getBoxByBasePointAndSize((class_2338)new class_2338(this.size, this.size, this.size), (class_2338)this.innerBoxPos);
        }

        void readFromNbt(class_2487 tag) {
            this.id = tag.method_10550("id");
            this.innerBoxPos = Helper.getVec3i((class_2487)tag, (String)"innerBoxPos");
            this.size = tag.method_10550("size");
            this.color = class_1767.method_7793((String)tag.method_10558("color"), (class_1767)class_1767.field_7963);
            this.ownerId = tag.method_25926("ownerId");
            this.ownerNameCache = tag.method_10558("ownerNameCache");
            this.currentEntranceDim = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(tag.method_10558("currentEntranceDim")));
            this.currentEntrancePos = Helper.getVec3i((class_2487)tag, (String)"currentEntrancePos");
            this.generation = tag.method_10550("generation");
        }

        void writeToNbt(class_2487 tag) {
            tag.method_10569("id", this.id);
            Helper.putVec3i((class_2487)tag, (String)"innerBoxPos", (class_2382)this.innerBoxPos);
            tag.method_10569("size", this.size);
            tag.method_10582("color", this.color.method_7792());
            tag.method_25927("ownerId", this.ownerId);
            tag.method_10582("ownerNameCache", this.ownerNameCache);
            tag.method_10582("currentEntranceDim", this.currentEntranceDim.method_29177().method_12832());
            Helper.putVec3i((class_2487)tag, (String)"currentEntrancePos", (class_2382)this.currentEntrancePos);
            tag.method_10569("generation", this.generation);
        }
    }
}

