/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled.block;

import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.apache.commons.lang3.Validate;
import qouteall.mini_scaled.ScaleBoxRecord;
import qouteall.mini_scaled.block.ScaleBoxPlaceholderBlock;
import qouteall.q_misc_util.MiscHelper;

public class ScaleBoxPlaceholderBlockEntity
extends class_2586 {
    public static class_2591<ScaleBoxPlaceholderBlockEntity> blockEntityType;
    public int boxId;

    public static void init() {
        blockEntityType = (class_2591)class_2378.method_10226((class_2378)class_2378.field_11137, (String)"mini_scaled:placeholder_block_entity", (Object)FabricBlockEntityTypeBuilder.create(ScaleBoxPlaceholderBlockEntity::new, (class_2248[])new class_2248[]{ScaleBoxPlaceholderBlock.instance}).build());
    }

    public ScaleBoxPlaceholderBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.boxId = tag.method_10550("boxId");
    }

    public class_2487 method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("boxId", this.boxId);
        return tag;
    }

    public void doTick() {
        if (this.field_11863.method_8608()) {
            return;
        }
        if (this.field_11863.method_8510() % 23L != 2L) {
            return;
        }
        this.checkValidity();
    }

    public static void staticTick(class_1937 world, class_2338 pos, class_2680 state, ScaleBoxPlaceholderBlockEntity blockEntity) {
        blockEntity.doTick();
    }

    public void checkValidity() {
        boolean dimEquals;
        ScaleBoxRecord.Entry entry = ScaleBoxRecord.getEntryById(this.boxId);
        if (entry == null) {
            System.out.println("invalid box with id " + this.boxId);
            this.destroy();
            return;
        }
        boolean posEquals = entry.currentEntrancePos.equals((Object)this.method_11016());
        if (!posEquals) {
            System.out.println("invalid box entrance position " + this.boxId + this.method_11016() + entry.currentEntrancePos);
            this.destroy();
            return;
        }
        boolean bl = dimEquals = entry.currentEntranceDim == this.field_11863.method_27983();
        if (!dimEquals) {
            System.out.println("invalid box dim " + this.boxId + this.field_11863.method_27983() + entry.currentEntranceDim);
            this.destroy();
            return;
        }
    }

    private void destroy() {
        Validate.isTrue((!this.field_11863.method_8608() ? 1 : 0) != 0);
        System.out.println("destroy scale box " + this.boxId);
        this.field_11863.method_8501(this.method_11016(), class_2246.field_10124.method_9564());
        this.method_11012();
    }

    private static void notifyPortalBreak(int boxId) {
        ScaleBoxRecord.Entry entry = ScaleBoxRecord.getEntryById(boxId);
        if (entry != null) {
            ++entry.generation;
            ScaleBoxRecord.get().method_78(true);
        }
    }

    public static void checkBlockIntegrity(int boxId) {
        boolean blockValid;
        ScaleBoxRecord.Entry entry = ScaleBoxRecord.getEntryById(boxId);
        if (entry == null) {
            return;
        }
        class_5321<class_1937> currentEntranceDim = entry.currentEntranceDim;
        if (currentEntranceDim == null) {
            System.err.println("null entrance dim " + boxId);
            return;
        }
        class_2338 currentEntrancePos = entry.currentEntrancePos;
        class_3218 entranceWorld = MiscHelper.getServer().method_3847(currentEntranceDim);
        if (entranceWorld == null) {
            System.err.println("invalid entrance dim " + currentEntranceDim);
            return;
        }
        boolean chunkLoaded = entranceWorld.method_22340(currentEntrancePos);
        if (!chunkLoaded) {
            return;
        }
        boolean bl = blockValid = entranceWorld.method_8320(currentEntrancePos).method_26204() == ScaleBoxPlaceholderBlock.instance;
        if (!blockValid) {
            ScaleBoxPlaceholderBlockEntity.notifyPortalBreak(boxId);
        }
    }
}

