/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class StateManager {
    private static final Set<WeakReference<IResettable>> resettableRefs = new HashSet<WeakReference<IResettable>>();

    public static void resetStates() {
        Iterator<WeakReference<IResettable>> iterator = resettableRefs.iterator();
        while (iterator.hasNext()) {
            IResettable ref = (IResettable)iterator.next().get();
            if (ref != null) {
                ref.resetState();
                continue;
            }
            iterator.remove();
        }
    }

    public static interface IResettable {
        default public void register() {
            resettableRefs.add(new WeakReference<IResettable>(this));
        }

        public void resetState();
    }
}

