/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.fabric;

import com.google.gson.Gson;
import fudge.notenoughcrashes.NotEnoughCrashes;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.ToIntFunction;
import net.minecraft.class_3797;

public class YarnVersion {
    public String gameVersion;
    public String separator;
    public int build;
    public String maven;
    public String version;
    public boolean stable;
    private static final String YARN_API_ENTRYPOINT = "https://meta.fabricmc.net/v2/versions/yarn/" + class_3797.method_16672().getName();
    private static final Path VERSION_FILE = NotEnoughCrashes.DIRECTORY.resolve("yarn-version.txt");
    private static String versionMemCache = null;

    public static String getLatestBuildForCurrentVersion() throws IOException {
        if (versionMemCache == null) {
            if (!Files.exists(VERSION_FILE, new LinkOption[0])) {
                URL url = new URL(YARN_API_ENTRYPOINT);
                URLConnection request = url.openConnection();
                request.connect();
                InputStream response = (InputStream)request.getContent();
                YarnVersion[] versions = (YarnVersion[])new Gson().fromJson((Reader)new InputStreamReader(response), YarnVersion[].class);
                if (versions.length == 0) {
                    throw new IllegalStateException("No yarn versions were received at the API endpoint. Received json: " + YarnVersion.getString(response));
                }
                String version = Arrays.stream(versions).max(Comparator.comparingInt((ToIntFunction<YarnVersion>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$getLatestBuildForCurrentVersion$0(fudge.notenoughcrashes.fabric.YarnVersion ), (Lfudge/notenoughcrashes/fabric/YarnVersion;)I)())).get().version;
                NotEnoughCrashes.ensureDirectoryExists();
                Files.write(VERSION_FILE, version.getBytes(), new OpenOption[0]);
                versionMemCache = version;
            } else {
                versionMemCache = new String(Files.readAllBytes(VERSION_FILE));
            }
        }
        return versionMemCache;
    }

    private static String getString(InputStream inputStream) throws IOException {
        return new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
    }

    private static /* synthetic */ int lambda$getLatestBuildForCurrentVersion$0(YarnVersion v) {
        return v.build;
    }
}

