/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rareice.forge.blocks.entities;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rareice.forge.ItemLocation;
import me.shedaniel.rareice.forge.RareIce;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.Nullable;

public class RareIceBlockEntity
extends BlockEntity
implements Clearable {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private static final ResourceLocation LOOT_TABLE = new ResourceLocation("rare-ice:chests/rare_ice");
    private final NonNullList<ItemStack> itemsContained = NonNullList.m_122779_();
    private final List<ItemLocation> itemsLocations = new ArrayList<ItemLocation>();
    private boolean setup = false;
    private int delay = 0;

    public RareIceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RareIce.RARE_ICE_TILE_ENTITY_TYPE.get(), pos, state);
    }

    public void m_6211_() {
        this.itemsContained.clear();
        this.itemsLocations.clear();
    }

    public NonNullList<ItemStack> getItemsContained() {
        return this.itemsContained;
    }

    public List<ItemLocation> getItemsLocations() {
        return this.itemsLocations;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_142466_(CompoundTag tag) {
        this.delay = tag.m_128451_("RevertDelay");
        this.itemsContained.clear();
        this.itemsLocations.clear();
        ListTag itemsTag = tag.m_128437_("Items", 10);
        for (int i = 0; i < itemsTag.size(); ++i) {
            CompoundTag compoundTag = itemsTag.m_128728_(i);
            this.itemsContained.add((Object)ItemStack.m_41712_((CompoundTag)compoundTag));
        }
        ListTag itemLocationsTag = tag.m_128437_("ItemLocations", 10);
        for (int i = 0; i < itemLocationsTag.size(); ++i) {
            CompoundTag compoundTag = itemLocationsTag.m_128728_(i);
            this.itemsLocations.add(ItemLocation.fromTag(compoundTag));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("RevertDelay", this.delay);
        ListTag itemsTag = new ListTag();
        ListTag itemLocationsTag = new ListTag();
        for (int i = 0; i < this.itemsLocations.size(); ++i) {
            CompoundTag compoundTag;
            ItemLocation itemLocation = this.itemsLocations.get(i);
            ItemStack stack = (ItemStack)this.itemsContained.get(i);
            if (!stack.m_41619_()) {
                compoundTag = new CompoundTag();
                stack.m_41739_(compoundTag);
                itemsTag.add((Object)compoundTag);
            }
            if (stack.m_41619_()) continue;
            compoundTag = new CompoundTag();
            itemLocation.toTag(compoundTag);
            itemLocationsTag.add((Object)compoundTag);
        }
        tag.m_128365_("Items", (Tag)itemsTag);
        tag.m_128365_("ItemLocations", (Tag)itemLocationsTag);
    }

    public void addLootTable(Level world) {
        this.setup = true;
    }

    public static void tick(Level world, BlockPos pos, BlockState blockState, RareIceBlockEntity blockEntity) {
        if (blockEntity.setup) {
            blockEntity.setup = false;
            blockEntity.delay = 0;
            LootTable lootTable = world.m_7654_().m_278653_().m_278676_(LOOT_TABLE);
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)world);
            ObjectArrayList drops = lootTable.m_287195_(builder.m_287235_(LootContextParamSets.f_81410_));
            int size = Mth.m_14045_((int)(world.f_46441_.m_188503_(5) - (world.f_46441_.m_188503_(1) + 2)), (int)0, (int)drops.size());
            if (drops.size() >= 1) {
                for (int i = 0; i < size; ++i) {
                    int index = world.f_46441_.m_188503_(drops.size());
                    blockEntity.addItem(world, (ItemStack)drops.get(index), null);
                    drops.remove(index);
                }
            }
        } else if (blockEntity.itemsContained.isEmpty()) {
            ++blockEntity.delay;
            if (blockEntity.delay > 20) {
                world.m_46597_(pos, Blocks.f_50126_.m_49966_());
                blockEntity.m_7651_();
            }
        } else {
            blockEntity.delay = 0;
        }
    }

    public InteractionResult addItem(Level world, ItemStack itemStack, Player nullablePlayer) {
        return this.addItem(world, itemStack, nullablePlayer, true);
    }

    public InteractionResult addItem(Level world, ItemStack itemStack, Player nullablePlayer, boolean actuallyDoIt) {
        if (itemStack.m_41720_() instanceof BlockItem && ((BlockItem)itemStack.m_41720_()).m_40614_().m_204297_().m_203656_(BlockTags.f_13047_)) {
            return InteractionResult.PASS;
        }
        if (this.getItemsContained().size() < 8 && itemStack.m_41613_() >= 1) {
            if (actuallyDoIt) {
                this.getItemsContained().add((Object)itemStack.m_41620_(1));
                RandomSource random = world.f_46441_;
                if (random == null) {
                    random = RANDOM;
                }
                this.getItemsLocations().add(new ItemLocation(random.m_188500_() * 0.95 + 0.1, random.m_188500_() * 0.7 + 0.1, random.m_188500_() * 0.95 + 0.1));
                this.updateListeners();
            }
            if (nullablePlayer != null && world.m_5776_()) {
                nullablePlayer.m_5496_(SoundEvents.f_11825_, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    private void updateListeners() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

