/*
 * Decompiled with CFR 0.152.
 */
package com.omircon.shield_bash;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.omircon.shield_bash.network.Network;
import com.omircon.shield_bash.network.ShieldBashPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE, modid="shield_bash")
public class ClientEvents {
    private static int cooldown = 0;

    public static void setup() {
        MinecraftForge.EVENT_BUS.addListener(ClientEvents::clientTick);
        MinecraftForge.EVENT_BUS.addListener(ClientEvents::keyboardEvent);
        MinecraftForge.EVENT_BUS.addListener(ClientEvents::mouseEvent);
        MinecraftForge.EVENT_BUS.addListener(ClientEvents::renderHand);
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (cooldown > 0) {
            --cooldown;
        }
    }

    @SubscribeEvent
    public static void keyboardEvent(InputEvent.KeyInputEvent event) {
        if (event.getKey() == Minecraft.func_71410_x().field_71474_y.field_74312_F.getKey().func_197937_c() && event.getAction() == 1) {
            ClientEvents.execute();
        }
    }

    @SubscribeEvent
    public static void mouseEvent(InputEvent.MouseInputEvent event) {
        if (event.getButton() == Minecraft.func_71410_x().field_71474_y.field_74312_F.getKey().func_197937_c() && event.getAction() == 1) {
            ClientEvents.execute();
        }
    }

    @SubscribeEvent
    public static void renderHand(RenderHandEvent event) {
        ClientPlayerEntity pPlayer = Minecraft.func_71410_x().field_71439_g;
        if (pPlayer.field_70733_aJ > 0.0f && pPlayer.func_184587_cr() && pPlayer.func_184607_cu().func_77973_b() == Items.field_185159_cQ) {
            event.setCanceled(true);
            Hand pHand = event.getHand();
            MatrixStack pMatrixStack = event.getMatrixStack();
            IRenderTypeBuffer pBuffer = event.getBuffers();
            int pCombinedLight = event.getLight();
            float pSwingProgress = event.getSwingProgress();
            float pEquippedProgress = event.getEquipProgress();
            boolean flag = pHand == Hand.MAIN_HAND;
            HandSide handside = flag ? pPlayer.func_184591_cq() : pPlayer.func_184591_cq().func_188468_a();
            ItemStack pStack = event.getItemStack();
            boolean flag3 = handside == HandSide.RIGHT;
            pMatrixStack.func_227860_a_();
            float f5 = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)pSwingProgress) * (float)Math.PI));
            float f6 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)pSwingProgress) * ((float)Math.PI * 2)));
            float f10 = -0.2f * MathHelper.func_76126_a((float)(pSwingProgress * (float)Math.PI));
            int l = flag3 ? 1 : -1;
            pMatrixStack.func_227861_a_((double)((float)l * f5), (double)f6, (double)f10);
            ClientEvents.applyItemArmTransform(pMatrixStack, handside, pEquippedProgress);
            ClientEvents.applyItemArmAttackTransform(pMatrixStack, handside, pSwingProgress);
            Minecraft.func_71410_x().func_175597_ag().func_228397_a_((LivingEntity)pPlayer, pStack, flag3 ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !flag3, pMatrixStack, pBuffer, pCombinedLight);
            pMatrixStack.func_227865_b_();
        }
    }

    public static void execute() {
        System.out.println("execute");
        if (Minecraft.func_71410_x().field_71462_r == null && Minecraft.func_71410_x().field_71439_g.func_184587_cr() && Minecraft.func_71410_x().field_71439_g.func_184607_cu().func_77973_b() == Items.field_185159_cQ && cooldown <= 0) {
            cooldown = 32;
            Network.sendToServer(new ShieldBashPacket());
            Minecraft.func_71410_x().field_71439_g.field_70733_aJ = 1.0f;
            Minecraft.func_71410_x().field_71439_g.func_226292_a_(Minecraft.func_71410_x().field_71439_g.func_184600_cs(), true);
        }
    }

    private static void applyItemArmTransform(MatrixStack pMatrixStack, HandSide pHand, float pEquippedProg) {
        int i = pHand == HandSide.RIGHT ? 1 : -1;
        pMatrixStack.func_227861_a_((double)((float)i * 0.56f), (double)(-0.52f + pEquippedProg * -0.6f), (double)-0.72f);
    }

    private static void applyItemArmAttackTransform(MatrixStack pMatrixStack, HandSide pHand, float pSwingProgress) {
        int i = pHand == HandSide.RIGHT ? 1 : -1;
        float f = MathHelper.func_76126_a((float)(pSwingProgress * pSwingProgress * (float)Math.PI));
        pMatrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)i * (45.0f + f * -20.0f)));
        float f1 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)pSwingProgress) * (float)Math.PI));
        pMatrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)i * f1 * -20.0f));
        pMatrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f1 * -80.0f));
        pMatrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)i * -45.0f));
    }
}

