/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.pipeline;

import java.util.List;
import java.util.Random;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.BiomeColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.rand.XoRoShiRoRandom;
import me.jellysquid.mods.sodium.client.world.biome.BlockColorsExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;

public class BlockRenderer {
    private final Random random = new XoRoShiRoRandom();
    private final BlockColorsExtended blockColors;
    private final BlockOcclusionCache occlusionCache;
    private final QuadLightData cachedQuadLightData = new QuadLightData();
    private final BiomeColorBlender biomeColorBlender;
    private final LightPipelineProvider lighters;
    private final boolean useAmbientOcclusion;

    public BlockRenderer(Minecraft client, LightPipelineProvider lighters, BiomeColorBlender biomeColorBlender) {
        this.blockColors = (BlockColorsExtended)client.func_184125_al();
        this.biomeColorBlender = biomeColorBlender;
        this.lighters = lighters;
        this.occlusionCache = new BlockOcclusionCache();
        this.useAmbientOcclusion = Minecraft.func_71379_u();
    }

    public boolean renderModel(IBlockDisplayReader world, BlockState state, BlockPos pos, IBakedModel model, ChunkModelBuffers buffers, boolean cull, long seed) {
        LightPipeline lighter = this.lighters.getLighter(this.getLightingMode(state, model));
        Vector3d offset = state.func_191059_e((IBlockReader)world, pos);
        boolean rendered = false;
        for (Direction dir : DirectionUtil.ALL_DIRECTIONS) {
            this.random.setSeed(seed);
            List sided = model.func_200117_a(state, dir, this.random);
            if (sided.isEmpty() || cull && !this.occlusionCache.shouldDrawSide(state, (IBlockReader)world, pos, dir)) continue;
            this.renderQuadList(world, state, pos, lighter, offset, buffers, sided, ModelQuadFacing.fromDirection(dir));
            rendered = true;
        }
        this.random.setSeed(seed);
        List all = model.func_200117_a(state, null, this.random);
        if (!all.isEmpty()) {
            this.renderQuadList(world, state, pos, lighter, offset, buffers, all, ModelQuadFacing.UNASSIGNED);
            rendered = true;
        }
        return rendered;
    }

    private void renderQuadList(IBlockDisplayReader world, BlockState state, BlockPos pos, LightPipeline lighter, Vector3d offset, ChunkModelBuffers buffers, List<BakedQuad> quads, ModelQuadFacing facing) {
        IBlockColor colorizer = null;
        ModelVertexSink sink = buffers.getSink(facing);
        sink.ensureCapacity(quads.size() * 4);
        ChunkRenderData.Builder renderData = buffers.getRenderData();
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            BakedQuad quad = quads.get(i);
            QuadLightData light = this.cachedQuadLightData;
            lighter.calculate((ModelQuadView)quad, pos, light, quad.func_178210_d(), quad.func_239287_f_());
            if (quad.func_178212_b() && colorizer == null) {
                colorizer = this.blockColors.getColorProvider(state);
            }
            this.renderQuad(world, state, pos, sink, offset, colorizer, quad, light, renderData);
        }
        sink.flush();
    }

    private void renderQuad(IBlockDisplayReader world, BlockState state, BlockPos pos, ModelVertexSink sink, Vector3d offset, IBlockColor colorProvider, BakedQuad bakedQuad, QuadLightData light, ChunkRenderData.Builder renderData) {
        ModelQuadView src = (ModelQuadView)bakedQuad;
        ModelQuadOrientation order = ModelQuadOrientation.orient(light.br);
        int[] colors = null;
        if (bakedQuad.func_178212_b()) {
            colors = this.biomeColorBlender.getColors(colorProvider, world, state, pos, src);
        }
        for (int dstIndex = 0; dstIndex < 4; ++dstIndex) {
            int srcIndex = order.getVertexIndex(dstIndex);
            float x = src.getX(srcIndex) + (float)offset.func_82615_a();
            float y = src.getY(srcIndex) + (float)offset.func_82617_b();
            float z = src.getZ(srcIndex) + (float)offset.func_82616_c();
            int color = ColorABGR.mul(colors != null ? colors[srcIndex] : -1, light.br[srcIndex]);
            float u = src.getTexU(srcIndex);
            float v = src.getTexV(srcIndex);
            int lm = light.lm[srcIndex];
            sink.writeQuad(x, y, z, color, u, v, lm);
        }
        TextureAtlasSprite sprite = src.getSprite();
        if (sprite != null) {
            renderData.addSprite(sprite);
        }
    }

    private LightMode getLightingMode(BlockState state, IBakedModel model) {
        if (this.useAmbientOcclusion && model.func_177555_b() && state.func_185906_d() == 0) {
            return LightMode.SMOOTH;
        }
        return LightMode.FLAT;
    }
}

