/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import me.jellysquid.mods.sodium.client.world.biome.BiomeCache;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorCache;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import me.jellysquid.mods.sodium.client.world.cloned.PackedIntegerArrayExtended;
import me.jellysquid.mods.sodium.client.world.cloned.palette.ClonedPalette;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BitArray;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;

public class WorldSlice
implements IBlockDisplayReader,
BiomeManager.IBiomeReader {
    private static final int SECTION_BLOCK_LENGTH = 16;
    private static final int SECTION_BLOCK_COUNT = 4096;
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private static final int NEIGHBOR_CHUNK_RADIUS = MathHelper.func_154354_b((int)2, (int)16) >> 4;
    private static final int SECTION_LENGTH = 1 + NEIGHBOR_CHUNK_RADIUS * 2;
    private static final int TABLE_LENGTH = MathHelper.func_151236_b((int)SECTION_LENGTH);
    private static final int TABLE_BITS = Integer.bitCount(TABLE_LENGTH - 1);
    private static final int SECTION_TABLE_ARRAY_SIZE = TABLE_LENGTH * TABLE_LENGTH * TABLE_LENGTH;
    private final World world;
    private final BlockState[][] blockStatesArrays;
    private ClonedChunkSection[] sections;
    private BiomeCache[] biomeCaches;
    private final Map<ColorResolver, BiomeColorCache> biomeColorCaches = new Reference2ObjectOpenHashMap();
    private ColorResolver prevColorResolver;
    private BiomeColorCache prevColorCache;
    private int baseX;
    private int baseY;
    private int baseZ;
    private SectionPos origin;

    public static ChunkRenderContext prepare(World world, SectionPos origin, ClonedChunkSectionCache sectionCache) {
        Chunk chunk = world.func_212866_a_(origin.func_177958_n(), origin.func_177952_p());
        ChunkSection section = chunk.func_76587_i()[origin.func_177956_o()];
        if (ChunkSection.func_222628_a((ChunkSection)section)) {
            return null;
        }
        MutableBoundingBox volume = new MutableBoundingBox(origin.func_218161_d() - 2, origin.func_218151_e() - 2, origin.func_218164_f() - 2, origin.func_218152_g() + 2, origin.func_218165_h() + 2, origin.func_218143_r() + 2);
        int minChunkX = origin.func_177958_n() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkY = origin.func_177956_o() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkZ = origin.func_177952_p() - NEIGHBOR_CHUNK_RADIUS;
        int maxChunkX = origin.func_177958_n() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkY = origin.func_177956_o() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkZ = origin.func_177952_p() + NEIGHBOR_CHUNK_RADIUS;
        ClonedChunkSection[] sections = new ClonedChunkSection[SECTION_TABLE_ARRAY_SIZE];
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                    sections[WorldSlice.getLocalSectionIndex((int)(chunkX - minChunkX), (int)(chunkY - minChunkY), (int)(chunkZ - minChunkZ))] = sectionCache.acquire(chunkX, chunkY, chunkZ);
                }
            }
        }
        return new ChunkRenderContext(origin, sections, volume);
    }

    public WorldSlice(World world) {
        this.world = world;
        this.sections = new ClonedChunkSection[SECTION_TABLE_ARRAY_SIZE];
        this.blockStatesArrays = new BlockState[SECTION_TABLE_ARRAY_SIZE][];
        this.biomeCaches = new BiomeCache[SECTION_TABLE_ARRAY_SIZE];
        for (int x = 0; x < SECTION_LENGTH; ++x) {
            for (int y = 0; y < SECTION_LENGTH; ++y) {
                for (int z = 0; z < SECTION_LENGTH; ++z) {
                    int i = WorldSlice.getLocalSectionIndex(x, y, z);
                    this.blockStatesArrays[i] = new BlockState[4096];
                    this.biomeCaches[i] = new BiomeCache(this.world);
                }
            }
        }
    }

    public void copyData(ChunkRenderContext context) {
        this.origin = context.getOrigin();
        this.sections = context.getSections();
        this.prevColorCache = null;
        this.prevColorResolver = null;
        this.biomeColorCaches.clear();
        this.baseX = this.origin.func_177958_n() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.baseY = this.origin.func_177956_o() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.baseZ = this.origin.func_177952_p() - NEIGHBOR_CHUNK_RADIUS << 4;
        for (int x = 0; x < SECTION_LENGTH; ++x) {
            for (int y = 0; y < SECTION_LENGTH; ++y) {
                for (int z = 0; z < SECTION_LENGTH; ++z) {
                    int idx = WorldSlice.getLocalSectionIndex(x, y, z);
                    this.biomeCaches[idx].reset();
                    this.unpackBlockData(this.blockStatesArrays[idx], this.sections[idx], context.getVolume());
                }
            }
        }
    }

    private void unpackBlockData(BlockState[] states, ClonedChunkSection section, MutableBoundingBox box) {
        if (this.origin.equals((Object)section.getPosition())) {
            this.unpackBlockDataZ(states, section);
        } else {
            this.unpackBlockDataR(states, section, box);
        }
    }

    private void unpackBlockDataR(BlockState[] states, ClonedChunkSection section, MutableBoundingBox box) {
        BitArray intArray = section.getBlockData();
        ClonedPalette<BlockState> palette = section.getBlockPalette();
        SectionPos pos = section.getPosition();
        int minBlockX = Math.max(box.field_78897_a, pos.func_218161_d());
        int maxBlockX = Math.min(box.field_78893_d, pos.func_218152_g());
        int minBlockY = Math.max(box.field_78895_b, pos.func_218151_e());
        int maxBlockY = Math.min(box.field_78894_e, pos.func_218165_h());
        int minBlockZ = Math.max(box.field_78896_c, pos.func_218164_f());
        int maxBlockZ = Math.min(box.field_78892_f, pos.func_218143_r());
        for (int y = minBlockY; y <= maxBlockY; ++y) {
            for (int z = minBlockZ; z <= maxBlockZ; ++z) {
                for (int x = minBlockX; x <= maxBlockX; ++x) {
                    int blockIdx = WorldSlice.getLocalBlockIndex(x & 0xF, y & 0xF, z & 0xF);
                    int value = intArray.func_188142_a(blockIdx);
                    states[blockIdx] = palette.get(value);
                }
            }
        }
    }

    private void unpackBlockDataZ(BlockState[] states, ClonedChunkSection section) {
        ((PackedIntegerArrayExtended)section.getBlockData()).copyUsingPalette(states, section.getBlockPalette());
    }

    public BlockState func_180495_p(BlockPos pos) {
        return this.getBlockState(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public BlockState getBlockState(int x, int y, int z) {
        int relX = x - this.baseX;
        int relY = y - this.baseY;
        int relZ = z - this.baseZ;
        return this.blockStatesArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)][WorldSlice.getLocalBlockIndex(relX & 0xF, relY & 0xF, relZ & 0xF)];
    }

    public BlockState getBlockStateRelative(int x, int y, int z) {
        return this.blockStatesArrays[WorldSlice.getLocalSectionIndex(x >> 4, y >> 4, z >> 4)][WorldSlice.getLocalBlockIndex(x & 0xF, y & 0xF, z & 0xF)];
    }

    public FluidState func_204610_c(BlockPos pos) {
        return this.func_180495_p(pos).func_204520_s();
    }

    public float func_230487_a_(Direction direction, boolean shaded) {
        return this.world.func_230487_a_(direction, shaded);
    }

    public WorldLightManager func_225524_e_() {
        return this.world.func_225524_e_();
    }

    public TileEntity func_175625_s(BlockPos pos) {
        return this.getBlockEntity(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public TileEntity getBlockEntity(int x, int y, int z) {
        int relX = x - this.baseX;
        int relY = y - this.baseY;
        int relZ = z - this.baseZ;
        return this.sections[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)].getBlockEntity(relX & 0xF, relY & 0xF, relZ & 0xF);
    }

    public int func_225525_a_(BlockPos pos, ColorResolver resolver) {
        BiomeColorCache cache;
        if (this.prevColorResolver == resolver) {
            cache = this.prevColorCache;
        } else {
            cache = this.biomeColorCaches.get(resolver);
            if (cache == null) {
                cache = new BiomeColorCache(resolver, this);
                this.biomeColorCaches.put(resolver, cache);
            }
            this.prevColorResolver = resolver;
            this.prevColorCache = cache;
        }
        return cache.getBlendedColor(pos);
    }

    public int func_226658_a_(LightType type, BlockPos pos) {
        int relX = pos.func_177958_n() - this.baseX;
        int relY = pos.func_177956_o() - this.baseY;
        int relZ = pos.func_177952_p() - this.baseZ;
        return this.sections[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)].getLightLevel(type, relX & 0xF, relY & 0xF, relZ & 0xF);
    }

    public int func_226659_b_(BlockPos pos, int ambientDarkness) {
        return 0;
    }

    public boolean func_226660_f_(BlockPos pos) {
        return false;
    }

    public Biome func_225526_b_(int x, int y, int z) {
        int x2 = (x >> 2) - (this.baseX >> 4);
        int z2 = (z >> 2) - (this.baseZ >> 4);
        ClonedChunkSection section = this.sections[WorldSlice.getLocalChunkIndex(x2, z2)];
        if (section != null) {
            return section.getBiomeForNoiseGen(x, y, z);
        }
        return this.world.func_225604_a_(x, y, z);
    }

    public Biome getBiome(int x, int y, int z) {
        int relX = x - this.baseX;
        int relY = y - this.baseY;
        int relZ = z - this.baseZ;
        return this.biomeCaches[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)].getBiome(this, x, relY >> 4, z);
    }

    public SectionPos getOrigin() {
        return this.origin;
    }

    public static int getLocalBlockIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    public static int getLocalSectionIndex(int x, int y, int z) {
        return y << TABLE_BITS << TABLE_BITS | z << TABLE_BITS | x;
    }

    public static int getLocalChunkIndex(int x, int z) {
        return z << TABLE_BITS | x;
    }
}

