/*
 * Decompiled with CFR 0.152.
 */
package net.thegrimsey.stoneholm;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.thegrimsey.stoneholm.SHConfig;
import net.thegrimsey.stoneholm.SHConfiguredStructures;
import net.thegrimsey.stoneholm.SHStructures;
import net.thegrimsey.stoneholm.processors.NoWaterProcessor;

@Mod(value="stoneholm")
public class Stoneholm {
    public static final String MODID = "stoneholm";
    public static final HashSet<Biome.BiomeCategory> SPAWNABLE_BIOME_CATEGORIES = Stream.of(Biome.BiomeCategory.FOREST, Biome.BiomeCategory.JUNGLE, Biome.BiomeCategory.DESERT, Biome.BiomeCategory.PLAINS, Biome.BiomeCategory.SAVANNA).collect(Collectors.toCollection(HashSet::new));
    public static SHConfig CONFIG;
    public static StructureProcessorType<NoWaterProcessor> NOWATER_PROCESSOR;

    public Stoneholm() {
        AutoConfig.register(SHConfig.class, JanksonConfigSerializer::new);
        CONFIG = (SHConfig)AutoConfig.getConfigHolder(SHConfig.class).getConfig();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        SHStructures.STRUCTURE_DEFERRED_REGISTER.register(modEventBus);
        modEventBus.addListener(this::setup);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::setupStructureSpacing);
    }

    void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SHStructures.registerStructureFeatures();
            SHConfiguredStructures.registerConfiguredStructures();
            Registry.m_122965_((Registry)Registry.f_122891_, (ResourceLocation)new ResourceLocation(MODID, "nowater_processor"), NOWATER_PROCESSOR);
        });
    }

    void setupStructureSpacing(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
            if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            StructureSettings worldStructureConfig = chunkGenerator.m_62205_();
            HashMap STStructureToMultiMap = new HashMap();
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                Biome.BiomeCategory biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.OCEAN || biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE) continue;
                Stoneholm.associateBiomeToConfiguredStructure(STStructureToMultiMap, SHConfiguredStructures.CONFIGURED_UNDERGROUND_VILLAGE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            ImmutableMap.Builder tempStructureToMultiMap = ImmutableMap.builder();
            worldStructureConfig.f_189361_.entrySet().stream().filter(entry -> !STStructureToMultiMap.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)tempStructureToMultiMap).put(arg_0));
            STStructureToMultiMap.forEach((key, value) -> tempStructureToMultiMap.put(key, (Object)ImmutableMultimap.copyOf((Multimap)value)));
            worldStructureConfig.f_189361_ = tempStructureToMultiMap.build();
            if (Stoneholm.CONFIG.disableVanillaVillages) {
                HashMap tempMap = new HashMap(serverLevel.m_7726_().m_8481_().m_62205_().m_64590_());
                tempMap.keySet().remove(StructureFeature.f_67028_);
                serverLevel.m_7726_().m_8481_().m_62205_().f_64582_ = tempMap;
            }
        }
    }

    private static void associateBiomeToConfiguredStructure(Map<StructureFeature<?>, HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> STStructureToMultiMap, ConfiguredStructureFeature<?, ?> configuredStructureFeature, ResourceKey<Biome> biomeRegistryKey) {
        STStructureToMultiMap.putIfAbsent(configuredStructureFeature.f_65403_, HashMultimap.create());
        HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> configuredStructureToBiomeMultiMap = STStructureToMultiMap.get(configuredStructureFeature.f_65403_);
        if (!configuredStructureToBiomeMultiMap.containsValue(biomeRegistryKey)) {
            configuredStructureToBiomeMultiMap.put(configuredStructureFeature, biomeRegistryKey);
        }
    }

    static {
        NOWATER_PROCESSOR = () -> NoWaterProcessor.CODEC;
    }
}

