/*
 * Decompiled with CFR 0.152.
 */
package net.thegrimsey.stoneholm.structures;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.EmptyPoolElement;
import net.minecraft.world.level.levelgen.feature.structures.JigsawJunction;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.thegrimsey.stoneholm.Stoneholm;
import net.thegrimsey.stoneholm.structures.UnderGroundVillageStructure;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoneholmGenerator {
    static final Logger LOGGER = LogManager.getLogger();

    public static Optional<PieceGenerator<JigsawConfiguration>> generate(PieceGeneratorSupplier.Context<JigsawConfiguration> inContext, PieceFactory pieceFactory, BlockPos pos) {
        int size = Stoneholm.CONFIG.VILLAGE_SIZE;
        if (size <= 0) {
            return Optional.empty();
        }
        RegistryAccess registryManager = inContext.f_197360_();
        Registry registry = registryManager.m_175515_(Registry.f_122884_);
        StructureTemplatePool structurePool = (StructureTemplatePool)registry.m_7745_(UnderGroundVillageStructure.START_POOL);
        WorldgenRandom chunkRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        chunkRandom.m_190068_(inContext.f_197354_(), inContext.f_197355_().f_45578_, inContext.f_197355_().f_45579_);
        StructurePoolElement startingElement = structurePool.m_69273_((Random)chunkRandom);
        if (startingElement == EmptyPoolElement.f_68856_) {
            return Optional.empty();
        }
        ChunkGenerator chunkGenerator = inContext.f_197352_();
        StructureManager structureManager = inContext.f_197359_();
        LevelHeightAccessor heightLimitView = inContext.f_197357_();
        Predicate biomePredicate = inContext.f_197358_();
        StructureFeature.m_67096_();
        Rotation blockRotation = Rotation.m_55956_((Random)chunkRandom);
        PoolElementStructurePiece poolStructurePiece = pieceFactory.create(structureManager, startingElement, pos, startingElement.m_69231_(), blockRotation, startingElement.m_6867_(structureManager, pos, blockRotation));
        BoundingBox pieceBoundingBox = poolStructurePiece.m_73547_();
        int centerX = (pieceBoundingBox.m_162399_() + pieceBoundingBox.m_162395_()) / 2;
        int centerZ = (pieceBoundingBox.m_162401_() + pieceBoundingBox.m_162398_()) / 2;
        int y = pos.m_123342_() + chunkGenerator.m_156174_(centerX, centerZ, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        if (!biomePredicate.test(chunkGenerator.m_7158_(QuartPos.m_175400_((int)centerX), QuartPos.m_175400_((int)y), QuartPos.m_175400_((int)centerZ)))) {
            return Optional.empty();
        }
        int yOffset = pieceBoundingBox.m_162396_() + poolStructurePiece.m_72647_();
        poolStructurePiece.m_6324_(0, y - yOffset, 0);
        return Optional.of((structurePiecesCollector, context) -> {
            ArrayList list = Lists.newArrayList((Object[])new PoolElementStructurePiece[]{poolStructurePiece});
            AABB box = new AABB((double)(centerX - 80), (double)(y - 80), (double)(centerZ - 80), (double)(centerX + 80 + 1), (double)(y + 80 + 1), (double)(centerZ + 80 + 1));
            StoneholmStructurePoolGenerator structurePoolGenerator = new StoneholmStructurePoolGenerator((Registry<StructureTemplatePool>)registry, size, pieceFactory, chunkGenerator, structureManager, list, (Random)chunkRandom);
            structurePoolGenerator.structurePieces.addLast(new StoneholmShapedPoolStructurePiece(poolStructurePiece, (MutableObject<VoxelShape>)new MutableObject((Object)Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)box), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)pieceBoundingBox)), (BooleanOp)BooleanOp.f_82685_)), 0, null));
            while (!structurePoolGenerator.structurePieces.isEmpty()) {
                StoneholmShapedPoolStructurePiece shapedPoolStructurePiece = structurePoolGenerator.structurePieces.removeFirst();
                structurePoolGenerator.generatePiece(shapedPoolStructurePiece.piece, shapedPoolStructurePiece.pieceShape, shapedPoolStructurePiece.currentSize, shapedPoolStructurePiece.sourceBlockPos, heightLimitView);
            }
            list.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesCollector).m_142679_(arg_0));
        });
    }

    public static interface PieceFactory {
        public PoolElementStructurePiece create(StructureManager var1, StructurePoolElement var2, BlockPos var3, int var4, Rotation var5, BoundingBox var6);
    }

    static final class StoneholmStructurePoolGenerator {
        final Registry<StructureTemplatePool> registry;
        final int maxSize;
        final PieceFactory pieceFactory;
        final ChunkGenerator chunkGenerator;
        final StructureManager structureManager;
        final List<? super PoolElementStructurePiece> children;
        final Random random;
        final Deque<StoneholmShapedPoolStructurePiece> structurePieces = Queues.newArrayDeque();
        final StructureTemplatePool fallback_down;
        final StructureTemplatePool fallback_side;
        final StructureTemplatePool end_cap;
        static final HashSet<ResourceLocation> terrainCheckIgnoredPools = new HashSet<ResourceLocation>(Arrays.asList(new ResourceLocation("stoneholm", "bee"), new ResourceLocation("stoneholm", "deco_blocks"), new ResourceLocation("stoneholm", "deco_coverings"), new ResourceLocation("stoneholm", "deco_wallpapers"), new ResourceLocation("stoneholm", "iron_golem"), new ResourceLocation("stoneholm", "villagers"), new ResourceLocation("stoneholm", "armor_stands")));

        StoneholmStructurePoolGenerator(Registry<StructureTemplatePool> registry, int maxSize, PieceFactory pieceFactory, ChunkGenerator chunkGenerator, StructureManager structureManager, List<? super PoolElementStructurePiece> children, Random random) {
            this.registry = registry;
            this.maxSize = maxSize;
            this.pieceFactory = pieceFactory;
            this.chunkGenerator = chunkGenerator;
            this.structureManager = structureManager;
            this.children = children;
            this.random = random;
            this.fallback_down = (StructureTemplatePool)registry.m_7745_(new ResourceLocation("stoneholm", "fallback_down_pool"));
            this.fallback_side = (StructureTemplatePool)registry.m_7745_(new ResourceLocation("stoneholm", "fallback_side_pool"));
            this.end_cap = (StructureTemplatePool)registry.m_7745_(new ResourceLocation("stoneholm", "end"));
        }

        void generatePiece(PoolElementStructurePiece piece, MutableObject<VoxelShape> pieceShape, int currentSize, BlockPos sourceStructureBlockPos, LevelHeightAccessor world) {
            StructurePoolElement structurePoolElement = piece.m_72645_();
            BlockPos sourcePos = piece.m_72646_();
            Rotation sourceRotation = piece.m_6830_();
            MutableObject<VoxelShape> mutableObject = new MutableObject<VoxelShape>();
            BoundingBox sourceBoundingBox = piece.m_73547_();
            int boundsMinY = sourceBoundingBox.m_162396_();
            BlockPos sourceBlock = sourcePos.m_141952_((Vec3i)(sourceStructureBlockPos == null ? BlockPos.f_121853_ : sourceStructureBlockPos));
            for (StructureTemplate.StructureBlockInfo structureBlock : structurePoolElement.m_6439_(this.structureManager, sourcePos, sourceRotation, this.random)) {
                boolean placed;
                StructurePoolElement iteratedStructureElement;
                MutableObject<VoxelShape> structureShape;
                if (sourceBlock.equals((Object)structureBlock.f_74675_)) continue;
                Direction structureBlockFaceDirection = JigsawBlock.m_54250_((BlockState)structureBlock.f_74676_);
                BlockPos structureBlockPosition = structureBlock.f_74675_;
                BlockPos structureBlockAimPosition = structureBlockPosition.m_142300_(structureBlockFaceDirection);
                ResourceLocation structureBlockTargetPoolId = new ResourceLocation(structureBlock.f_74677_.m_128461_("pool"));
                Optional targetPool = this.registry.m_6612_(structureBlockTargetPoolId);
                if (targetPool.isEmpty() || ((StructureTemplatePool)targetPool.get()).m_69278_() == 0 && !Objects.equals(structureBlockTargetPoolId, Pools.f_127186_.getRegistryName())) continue;
                boolean ignoredPool = terrainCheckIgnoredPools.contains(structureBlockTargetPoolId);
                ResourceLocation terminatorPoolId = ((StructureTemplatePool)targetPool.get()).m_69263_();
                Optional terminatorPool = this.registry.m_6612_(terminatorPoolId);
                if (terminatorPool.isEmpty() || ((StructureTemplatePool)terminatorPool.get()).m_69278_() == 0 && !Objects.equals(terminatorPoolId, Pools.f_127186_.getRegistryName())) continue;
                boolean containsPosition = sourceBoundingBox.m_71051_((Vec3i)structureBlockAimPosition);
                if (containsPosition) {
                    structureShape = mutableObject;
                    if (mutableObject.getValue() == null) {
                        mutableObject.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)sourceBoundingBox)));
                    }
                } else {
                    structureShape = pieceShape;
                }
                ArrayList possibleElementsToSpawn = Lists.newArrayList();
                if (currentSize < this.maxSize) {
                    possibleElementsToSpawn.addAll(((StructureTemplatePool)targetPool.get()).m_69276_(this.random));
                }
                possibleElementsToSpawn.addAll(((StructureTemplatePool)terminatorPool.get()).m_69276_(this.random));
                Iterator iterator = possibleElementsToSpawn.iterator();
                while (iterator.hasNext() && (iteratedStructureElement = (StructurePoolElement)iterator.next()) != EmptyPoolElement.f_68856_ && !(placed = this.tryPlacePiece(piece, currentSize, world, boundsMinY, structureBlock, structureShape, structureBlockFaceDirection, structureBlockPosition, structureBlockAimPosition, iteratedStructureElement, currentSize >= 2 && !ignoredPool))) {
                }
            }
        }

        boolean tryPlacePiece(PoolElementStructurePiece piece, int currentSize, LevelHeightAccessor world, int boundsMinY, StructureTemplate.StructureBlockInfo structureBlock, MutableObject<VoxelShape> structureShape, Direction structureBlockFaceDirection, BlockPos structureBlockPosition, BlockPos structureBlockAimPosition, StructurePoolElement element, boolean doTerrainCheck) {
            int j = structureBlockPosition.m_123342_() - boundsMinY;
            int t = boundsMinY + j;
            int pieceGroundLevelDelta = piece.m_72647_();
            for (Rotation randomizedRotation : Rotation.m_55958_((Random)this.random)) {
                List structureBlocksInStructure = element.m_6439_(this.structureManager, BlockPos.f_121853_, randomizedRotation, this.random);
                for (StructureTemplate.StructureBlockInfo structureBlockInfo : structureBlocksInStructure) {
                    if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)structureBlock, (StructureTemplate.StructureBlockInfo)structureBlockInfo)) continue;
                    BlockPos structureBlockPos = structureBlockInfo.f_74675_;
                    BlockPos structureBlockAimDelta = structureBlockAimPosition.m_141950_((Vec3i)structureBlockPos);
                    BoundingBox iteratedStructureBoundingBox = element.m_6867_(this.structureManager, structureBlockAimDelta, randomizedRotation);
                    int structureBlockY = structureBlockPos.m_123342_();
                    int o = j - structureBlockY + JigsawBlock.m_54250_((BlockState)structureBlock.f_74676_).m_122430_();
                    int adjustedMinY = boundsMinY + o;
                    int pieceYOffset = adjustedMinY - iteratedStructureBoundingBox.m_162396_();
                    BoundingBox offsetBoundingBox = iteratedStructureBoundingBox.m_162367_(0, pieceYOffset, 0);
                    if (Shapes.m_83157_((VoxelShape)((VoxelShape)structureShape.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)offsetBoundingBox).m_82406_(0.25)), (BooleanOp)BooleanOp.f_82683_)) continue;
                    if (doTerrainCheck && structureBlockFaceDirection != Direction.DOWN) {
                        boolean maxXminZ;
                        boolean minXmaxZ;
                        int maxYBuffer = 3;
                        int maxY = offsetBoundingBox.m_162400_() + maxYBuffer;
                        boolean minCorner = maxY > this.chunkGenerator.m_156174_(offsetBoundingBox.m_162395_(), offsetBoundingBox.m_162398_(), Heightmap.Types.WORLD_SURFACE_WG, world);
                        boolean maxCorner = maxY > this.chunkGenerator.m_156174_(offsetBoundingBox.m_162399_(), offsetBoundingBox.m_162401_(), Heightmap.Types.WORLD_SURFACE_WG, world);
                        int overTerrainCorners = (minCorner ? 1 : 0) + ((minXmaxZ = maxY > this.chunkGenerator.m_156174_(offsetBoundingBox.m_162395_(), offsetBoundingBox.m_162401_(), Heightmap.Types.WORLD_SURFACE_WG, world)) ? 1 : 0) + (maxCorner ? 1 : 0) + ((maxXminZ = maxY > this.chunkGenerator.m_156174_(offsetBoundingBox.m_162399_(), offsetBoundingBox.m_162398_(), Heightmap.Types.WORLD_SURFACE_WG, world)) ? 1 : 0);
                        if (overTerrainCorners > 1) {
                            element = this.end_cap.m_69273_(this.random);
                            if (overTerrainCorners > 2) {
                                element = currentSize + 2 > this.maxSize ? this.end_cap.m_69273_(this.random) : this.fallback_side.m_69273_(this.random);
                            }
                            return this.tryPlacePiece(piece, currentSize, boundsMinY, structureBlock, structureShape, structureBlockPosition, structureBlockAimPosition, element);
                        }
                    }
                    StructureTemplatePool.Projection iteratedProjection = element.m_69230_();
                    BlockPos offsetBlockPos = structureBlockAimDelta.m_142082_(0, pieceYOffset, 0);
                    structureShape.setValue((Object)Shapes.m_83113_((VoxelShape)((VoxelShape)structureShape.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)offsetBoundingBox)), (BooleanOp)BooleanOp.f_82685_));
                    int s = pieceGroundLevelDelta - o;
                    PoolElementStructurePiece poolStructurePiece = this.pieceFactory.create(this.structureManager, element, offsetBlockPos, s, randomizedRotation, offsetBoundingBox);
                    piece.m_72635_(new JigsawJunction(structureBlockAimPosition.m_123341_(), t - j + pieceGroundLevelDelta, structureBlockAimPosition.m_123343_(), o, iteratedProjection));
                    poolStructurePiece.m_72635_(new JigsawJunction(structureBlockPosition.m_123341_(), t - structureBlockY + s, structureBlockPosition.m_123343_(), -o, StructureTemplatePool.Projection.RIGID));
                    this.children.add((PoolElementStructurePiece)poolStructurePiece);
                    if (currentSize + 1 <= this.maxSize) {
                        this.structurePieces.addLast(new StoneholmShapedPoolStructurePiece(poolStructurePiece, structureShape, currentSize + 1, structureBlockPos));
                    }
                    return true;
                }
            }
            return false;
        }

        boolean tryPlacePiece(PoolElementStructurePiece piece, int currentSize, int boundsMinY, StructureTemplate.StructureBlockInfo structureBlock, MutableObject<VoxelShape> structureShape, BlockPos structureBlockPosition, BlockPos structureBlockAimPosition, StructurePoolElement element) {
            int j = structureBlockPosition.m_123342_() - boundsMinY;
            int t = boundsMinY + j;
            int pieceGroundLevelDelta = piece.m_72647_();
            for (Rotation randomizedRotation : Rotation.m_55958_((Random)this.random)) {
                List structureBlocksInStructure = element.m_6439_(this.structureManager, BlockPos.f_121853_, randomizedRotation, this.random);
                for (StructureTemplate.StructureBlockInfo structureBlockInfo : structureBlocksInStructure) {
                    if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)structureBlock, (StructureTemplate.StructureBlockInfo)structureBlockInfo)) continue;
                    BlockPos structureBlockPos = structureBlockInfo.f_74675_;
                    BlockPos structureBlockAimDelta = structureBlockAimPosition.m_141950_((Vec3i)structureBlockPos);
                    BoundingBox iteratedStructureBoundingBox = element.m_6867_(this.structureManager, structureBlockAimDelta, randomizedRotation);
                    int structureBlockY = structureBlockPos.m_123342_();
                    int o = j - structureBlockY + JigsawBlock.m_54250_((BlockState)structureBlock.f_74676_).m_122430_();
                    int adjustedMinY = boundsMinY + o;
                    int pieceYOffset = adjustedMinY - iteratedStructureBoundingBox.m_162396_();
                    BoundingBox offsetBoundingBox = iteratedStructureBoundingBox.m_162367_(0, pieceYOffset, 0);
                    if (Shapes.m_83157_((VoxelShape)((VoxelShape)structureShape.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)offsetBoundingBox).m_82406_(0.25)), (BooleanOp)BooleanOp.f_82683_)) continue;
                    StructureTemplatePool.Projection iteratedProjection = element.m_69230_();
                    BlockPos offsetBlockPos = structureBlockAimDelta.m_142082_(0, pieceYOffset, 0);
                    structureShape.setValue((Object)Shapes.m_83113_((VoxelShape)((VoxelShape)structureShape.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)offsetBoundingBox)), (BooleanOp)BooleanOp.f_82685_));
                    int s = pieceGroundLevelDelta - o;
                    PoolElementStructurePiece poolStructurePiece = this.pieceFactory.create(this.structureManager, element, offsetBlockPos, s, randomizedRotation, offsetBoundingBox);
                    piece.m_72635_(new JigsawJunction(structureBlockAimPosition.m_123341_(), t - j + pieceGroundLevelDelta, structureBlockAimPosition.m_123343_(), o, iteratedProjection));
                    poolStructurePiece.m_72635_(new JigsawJunction(structureBlockPosition.m_123341_(), t - structureBlockY + s, structureBlockPosition.m_123343_(), -o, StructureTemplatePool.Projection.RIGID));
                    this.children.add((PoolElementStructurePiece)poolStructurePiece);
                    if (currentSize + 1 <= this.maxSize) {
                        this.structurePieces.addLast(new StoneholmShapedPoolStructurePiece(poolStructurePiece, structureShape, currentSize + 1, structureBlockPos));
                    }
                    return true;
                }
            }
            return false;
        }
    }

    record StoneholmShapedPoolStructurePiece(PoolElementStructurePiece piece, MutableObject<VoxelShape> pieceShape, int currentSize, BlockPos sourceBlockPos) {
    }
}

