/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init;

import com.swdteam.main.Tardim;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import org.apache.logging.log4j.Level;

public class ItemRenderingRegistry {
    private static List<ItemRenderInfo> guiRenders = new ArrayList<ItemRenderInfo>();

    public static ItemRenderInfo addItemRenderer(Item item) {
        ItemRenderInfo ir = new ItemRenderInfo(item);
        guiRenders.add(ir);
        return ir;
    }

    public static List<ItemRenderInfo> getGuiRenders() {
        return guiRenders;
    }

    public static class ItemRenderInfo {
        private Map<ItemTransforms.TransformType, ItemModelMatch> transforms = new HashMap<ItemTransforms.TransformType, ItemModelMatch>();
        private ResourceLocation defaultModelLocation;
        private Item item;

        public ItemRenderInfo(Item i) {
            this.item = i;
            ResourceLocation rlPath = i.getRegistryName();
            this.defaultModelLocation = new ModelResourceLocation(rlPath, "inventory");
        }

        public void addTransformType(String s, ItemTransforms.TransformType type) {
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(this.item.getRegistryName() + "_" + s, "inventory"));
            this.transforms.put(type, new ItemModelMatch(this, s, type));
        }

        public Map<ItemTransforms.TransformType, ItemModelMatch> getTransforms() {
            return this.transforms;
        }

        public Item getItem() {
            return this.item;
        }

        public ResourceLocation getDefaultModelLocation() {
            return this.defaultModelLocation;
        }

        public static class ItemModelMatch {
            private ItemTransforms.TransformType type;
            private ResourceLocation modelLocation;
            private SimpleBakedModel model;

            public ItemModelMatch(ItemRenderInfo iri, String s, ItemTransforms.TransformType type) {
                this.modelLocation = new ModelResourceLocation(iri.getItem().getRegistryName() + "_" + s, "inventory");
                Tardim.LOGGER.log(Level.INFO, (Object)iri.defaultModelLocation);
                Tardim.LOGGER.log(Level.INFO, (Object)this.modelLocation);
                this.type = type;
            }

            public ResourceLocation getModelLocation() {
                return this.modelLocation;
            }

            public ItemTransforms.TransformType getType() {
                return this.type;
            }

            public void setModel(SimpleBakedModel model) {
                this.model = model;
            }

            public SimpleBakedModel getModel() {
                return this.model;
            }
        }
    }
}

