/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.block;

import com.swdteam.common.block.ITardimPart;
import com.swdteam.common.init.TRDItems;
import com.swdteam.common.init.TRDSounds;
import com.swdteam.common.item.ItemTardim;
import com.swdteam.main.Tardim;
import com.swdteam.tardim.TardimData;
import com.swdteam.tardim.TardimManager;
import com.swdteam.tileentity.TileEntityTardim;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockTardimDoors
extends Block
implements ITardimPart {
    public static final VoxelShape CLOSED_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    public static final VoxelShape CLOSED_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape CLOSED_EAST = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape CLOSED_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    public static final VoxelShape OPEN_NORTH = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)8.0), (VoxelShape)Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape OPEN_SOUTH = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)3.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)13.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape OPEN_EAST = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape OPEN_WEST = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape OPEN_COL_NORTH = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)8.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape OPEN_COL_SOUTH = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)1.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape OPEN_COL_EAST = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), (VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape OPEN_COL_WEST = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)1.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)8.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty FRONT = BooleanProperty.m_61465_((String)"front");
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final DirectionProperty BUILT_FACING = DirectionProperty.m_61546_((String)"built_facing", (Predicate)Direction.Plane.HORIZONTAL);

    public BlockTardimDoors(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FRONT, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        boolean open = (Boolean)state.m_61143_((Property)OPEN);
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return open ? OPEN_NORTH : CLOSED_NORTH;
            }
            case SOUTH: {
                return open ? OPEN_SOUTH : CLOSED_SOUTH;
            }
            case EAST: {
                return open ? OPEN_EAST : CLOSED_EAST;
            }
            case WEST: {
                return open ? OPEN_WEST : CLOSED_WEST;
            }
        }
        return super.m_5940_(state, p_60556_, p_60557_, p_60558_);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter p_60573_, BlockPos p_60574_, CollisionContext p_60575_) {
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            switch ((Direction)state.m_61143_((Property)FACING)) {
                case NORTH: {
                    return OPEN_COL_NORTH;
                }
                case SOUTH: {
                    return OPEN_COL_SOUTH;
                }
                case EAST: {
                    return OPEN_COL_EAST;
                }
                case WEST: {
                    return OPEN_COL_WEST;
                }
            }
        }
        return super.m_5939_(state, p_60573_, p_60574_, p_60575_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_52803_) {
        p_52803_.m_61104_(new Property[]{HALF, FACING, OPEN, FRONT, BUILT_FACING});
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, InteractionHand p_60507_, BlockHitResult p_60508_) {
        if (!p_60504_.f_46443_ && p_60507_ == p_60506_.m_7655_()) {
            Level w = p_60504_;
            boolean isFront = (Boolean)p_60503_.m_61143_((Property)FRONT);
            DoubleBlockHalf half = (DoubleBlockHalf)p_60503_.m_61143_(HALF);
            boolean open = (Boolean)p_60503_.m_61143_((Property)OPEN);
            BlockPos center = Tardim.INSTANCE.getCenter(w, p_60505_);
            BlockEntity be = w.m_7702_(center);
            int keyID = -1;
            if (be != null && be instanceof TileEntityTardim) {
                keyID = ((TileEntityTardim)be).tardimID;
            }
            TardimData data = TardimManager.getTardim(keyID);
            if (Tardim.INSTANCE.isDamaged(w, p_60505_)) {
                ItemTardim.destroyTardim(w, center, (Direction)p_60503_.m_61143_((Property)BUILT_FACING));
            }
            if (isFront) {
                if (data.hasPermission(p_60506_)) {
                    if (p_60506_.m_21120_(p_60507_).m_41720_() == TRDItems.TARDIM_KEY.get() && keyID != -1) {
                        ItemStack stack = p_60506_.m_21120_(p_60507_);
                        if (!stack.m_41782_()) {
                            stack.m_41751_(new CompoundTag());
                        }
                        if (!stack.m_41783_().m_128441_("key_id")) {
                            stack.m_41783_().m_128405_("key_id", keyID);
                            p_60506_.m_5661_((Component)new TextComponent("TARDIM bound to key").m_130940_(ChatFormatting.DARK_GREEN).m_130940_(ChatFormatting.BOLD), true);
                            return InteractionResult.CONSUME;
                        }
                        if (data != null && stack.m_41783_().m_128451_("key_id") == keyID) {
                            data.setLocked(!data.isLocked());
                            data.save();
                            w.m_5594_(null, p_60505_, (SoundEvent)TRDSounds.TARDIM_LOCK.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
                            p_60506_.m_5661_((Component)new TextComponent("TARDIM has been " + (data.isLocked() ? "locked" : "unlocked")).m_130940_(ChatFormatting.DARK_GREEN).m_130940_(ChatFormatting.BOLD), true);
                            if (((Boolean)p_60503_.m_61143_((Property)OPEN)).booleanValue()) {
                                w.m_46597_(p_60505_, (BlockState)w.m_8055_(p_60505_).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!open)));
                                BlockPos pos = half == DoubleBlockHalf.LOWER ? p_60505_.m_7494_() : p_60505_.m_7495_();
                                w.m_46597_(pos, (BlockState)w.m_8055_(pos).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!open)));
                                w.m_5898_(null, open ? 1012 : 1006, p_60505_, 0);
                            }
                            return InteractionResult.CONSUME;
                        }
                        p_60506_.m_5661_((Component)new TextComponent("This is not the correct key").m_130940_(ChatFormatting.DARK_RED).m_130940_(ChatFormatting.BOLD), true);
                        return InteractionResult.CONSUME;
                    }
                } else {
                    p_60506_.m_5661_((Component)new TextComponent("You do not have permission to interact with " + data.getOwnerName() + "'s TARDIM").m_130940_(ChatFormatting.DARK_RED).m_130940_(ChatFormatting.BOLD), true);
                    return InteractionResult.CONSUME;
                }
                if (data != null && data.isLocked()) {
                    w.m_5594_(null, p_60505_, (SoundEvent)TRDSounds.TARDIM_LOCKED.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
                    p_60506_.m_5661_((Component)new TextComponent("Door is locked").m_130940_(ChatFormatting.DARK_RED).m_130940_(ChatFormatting.BOLD), true);
                    return InteractionResult.CONSUME;
                }
                if (data != null && data.hasPermission(p_60506_)) {
                    if (data.getOwner().equals(p_60506_.m_36316_().getId())) {
                        data.setOwner(p_60506_);
                        data.save();
                    }
                    w.m_46597_(p_60505_, (BlockState)w.m_8055_(p_60505_).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!open)));
                    BlockPos pos = half == DoubleBlockHalf.LOWER ? p_60505_.m_7494_() : p_60505_.m_7495_();
                    w.m_46597_(pos, (BlockState)w.m_8055_(pos).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!open)));
                    w.m_5898_(null, open ? 1012 : 1006, p_60505_, 0);
                } else {
                    p_60506_.m_5661_((Component)new TextComponent("You do not have permission to enter " + data.getOwnerName() + "'s TARDIM").m_130940_(ChatFormatting.DARK_RED).m_130940_(ChatFormatting.BOLD), true);
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    public PushReaction m_5537_(BlockState p_49353_) {
        return PushReaction.BLOCK;
    }
}

