/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.block;

import com.swdteam.common.init.TRDSounds;
import com.swdteam.common.init.TRDTiles;
import com.swdteam.tardim.TardimData;
import com.swdteam.tardim.TardimManager;
import com.swdteam.tileentity.TileEntityTardimInteriorDoors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockTardimInteriorDoors
extends BaseEntityBlock {
    public static final VoxelShape CLOSED_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    public static final VoxelShape CLOSED_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape CLOSED_EAST = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape CLOSED_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    public static final VoxelShape OPEN_NORTH = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)8.0), (VoxelShape)Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape OPEN_SOUTH = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)3.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)13.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape OPEN_EAST = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape OPEN_WEST = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape COLLIDER = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;

    public BlockTardimInteriorDoors(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        boolean open = (Boolean)state.m_61143_((Property)OPEN);
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case SOUTH: {
                return open ? OPEN_NORTH : CLOSED_NORTH;
            }
            case NORTH: {
                return open ? OPEN_SOUTH : CLOSED_SOUTH;
            }
            case WEST: {
                return open ? OPEN_EAST : CLOSED_EAST;
            }
            case EAST: {
                return open ? OPEN_WEST : CLOSED_WEST;
            }
        }
        return super.m_5940_(state, p_60556_, p_60557_, p_60558_);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter p_60573_, BlockPos p_60574_, CollisionContext p_60575_) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return Shapes.m_83040_();
        }
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return COLLIDER;
        }
        return super.m_5939_(state, p_60573_, p_60574_, p_60575_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_52803_) {
        p_52803_.m_61104_(new Property[]{HALF, FACING, OPEN});
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, InteractionHand p_60507_, BlockHitResult p_60508_) {
        if (!p_60504_.f_46443_ && p_60507_ == p_60506_.m_7655_()) {
            TardimData data = TardimManager.getFromPos(p_60505_);
            if (data != null && !data.isInFlight()) {
                Level w = p_60504_;
                if (data.isLocked()) {
                    p_60506_.m_5661_((Component)new TextComponent("TARDIM doors are locked").m_130940_(ChatFormatting.DARK_RED).m_130940_(ChatFormatting.BOLD), true);
                    w.m_5594_(null, p_60505_, (SoundEvent)TRDSounds.TARDIM_LOCKED.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
                    if (((Boolean)p_60503_.m_61143_((Property)OPEN)).booleanValue()) {
                        this.doDoorThingy(w, p_60503_, p_60505_, true);
                    }
                } else {
                    this.doDoorThingy(w, p_60503_, p_60505_, (Boolean)p_60503_.m_61143_((Property)OPEN));
                }
            } else {
                p_60506_.m_5661_((Component)new TextComponent("TARDIM is currently in flight").m_130940_(ChatFormatting.DARK_RED).m_130940_(ChatFormatting.BOLD), true);
                if (((Boolean)p_60503_.m_61143_((Property)OPEN)).booleanValue()) {
                    this.doDoorThingy(p_60504_, p_60503_, p_60505_, true);
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    public void doDoorThingy(Level w, BlockState state, BlockPos position, boolean doorState) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        boolean open = doorState;
        w.m_46597_(position, (BlockState)w.m_8055_(position).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!open)));
        BlockPos pos = half == DoubleBlockHalf.LOWER ? position.m_7494_() : position.m_7495_();
        w.m_46597_(pos, (BlockState)w.m_8055_(pos).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!open)));
        w.m_5898_(null, open ? 1012 : 1006, position, 0);
    }

    public PushReaction m_5537_(BlockState p_49353_) {
        return PushReaction.BLOCK;
    }

    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new TileEntityTardimInteriorDoors(p_153215_, p_153216_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_152160_, BlockState p_152161_, BlockEntityType<T> p_152162_) {
        return BlockTardimInteriorDoors.m_152132_(p_152162_, (BlockEntityType)((BlockEntityType)TRDTiles.TILE_TARDIM_INTERIOR_DOORS.get()), TileEntityTardimInteriorDoors::tick);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.f_46443_) {
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                worldIn.m_46961_(pos.m_7494_(), false);
            } else {
                worldIn.m_46961_(pos.m_7495_(), false);
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (!world.f_46443_) {
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                world.m_46961_(pos.m_7494_(), false);
            } else {
                world.m_46961_(pos.m_7495_(), false);
            }
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    protected static void preventCreativeDropFromBottomPart(Level p_52904_, BlockPos p_52905_, BlockState p_52906_, Player p_52907_) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)p_52906_.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = p_52904_.m_8055_(blockpos = p_52905_.m_7495_())).m_60713_(p_52906_.m_60734_()) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            p_52904_.m_7731_(blockpos, blockstate1, 35);
            p_52904_.m_5898_(p_52907_, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }
}

