/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.command.tardim;

import com.swdteam.common.command.tardim.CommandTardimBase;
import com.swdteam.tardim.TardimData;
import com.swdteam.tardim.TardimManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;

public class CommandAddCoord
extends CommandTardimBase {
    @Override
    public void execute(String[] args, Player player, BlockPos pos, CommandTardimBase.CommandSource source) {
        TardimData data;
        if (args.length == 2 && (data = TardimManager.getFromPos(pos)) != null) {
            if (data.hasPermission(player)) {
                try {
                    int amount = Integer.parseInt(args[1]);
                    if (data.getTravelLocation() == null) {
                        data.setTravelLocation(new TardimData.Location(data.getCurrentLocation()));
                    }
                    if (args[0].equalsIgnoreCase("x")) {
                        data.getTravelLocation().addPosition(amount, 0, 0);
                    } else if (args[0].equalsIgnoreCase("y")) {
                        data.getTravelLocation().addPosition(0, amount, 0);
                    } else if (args[0].equalsIgnoreCase("z")) {
                        data.getTravelLocation().addPosition(0, 0, amount);
                    }
                    CommandAddCoord.sendResponse(player, "Coords set: " + data.getTravelLocation().getPos().m_123341_() + ", " + data.getTravelLocation().getPos().m_123342_() + ", " + data.getTravelLocation().getPos().m_123343_(), CommandTardimBase.ResponseType.COMPLETE, source);
                }
                catch (Exception e) {
                    CommandAddCoord.sendResponse(player, "Invalid coordinates, defaulting to current", CommandTardimBase.ResponseType.FAIL, source);
                }
            } else {
                CommandAddCoord.sendResponse(player, "You do not have permission", CommandTardimBase.ResponseType.FAIL, source);
            }
        }
    }

    @Override
    public String getCommandName() {
        return "coord-add";
    }

    @Override
    public String getUsage() {
        return "/coord-add <axis> <amount>";
    }

    @Override
    public CommandTardimBase.CommandSource allowedSource() {
        return CommandTardimBase.CommandSource.BOTH;
    }
}

