/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.command.tardim;

import com.swdteam.common.command.tardim.CommandTardimBase;
import com.swdteam.common.init.TRDSounds;
import com.swdteam.common.item.ItemTardim;
import com.swdteam.tardim.TardimData;
import com.swdteam.tardim.TardimManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CommandDemat
extends CommandTardimBase {
    @Override
    public void execute(String[] args, Player player, BlockPos pos, CommandTardimBase.CommandSource source) {
        TardimData data = TardimManager.getFromPos(pos);
        if (data != null) {
            if (data.hasPermission(player)) {
                if (data.isInFlight()) {
                    CommandDemat.sendResponse(player, "TARDIM is already in flight", CommandTardimBase.ResponseType.FAIL, source);
                } else {
                    TardimData.Location loc = data.getCurrentLocation();
                    ServerLevel level = player.m_20194_().m_129880_(loc.getLevel());
                    ItemTardim.destroyTardim((Level)level, loc.getPos(), Direction.NORTH);
                    data.setInFlight(true);
                    if (data.getTravelLocation() == null) {
                        data.setTravelLocation(new TardimData.Location(data.getCurrentLocation()));
                    }
                    data.setTimeEnteredFlight();
                    data.save();
                    System.out.println(loc.getPos());
                    CommandDemat.sendResponse(player, "TARDIM is taking off", CommandTardimBase.ResponseType.COMPLETE, source);
                    player.f_19853_.m_5594_(null, pos, (SoundEvent)TRDSounds.TARDIM_TAKEOFF.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                }
            } else {
                CommandDemat.sendResponse(player, "You do not have permission", CommandTardimBase.ResponseType.FAIL, source);
            }
        }
    }

    @Override
    public String getCommandName() {
        return "demat";
    }

    @Override
    public String getUsage() {
        return "/demat";
    }

    @Override
    public CommandTardimBase.CommandSource allowedSource() {
        return CommandTardimBase.CommandSource.BOTH;
    }
}

