/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.command.tardim;

import com.swdteam.common.command.tardim.CommandTardimBase;
import com.swdteam.common.command.tardim.CommandTravel;
import com.swdteam.common.data.DimensionMapReloadListener;
import com.swdteam.tardim.TardimManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CommandFuelCalculator
extends CommandTardimBase {
    @Override
    public void execute(String[] args, Player player, BlockPos pos, CommandTardimBase.CommandSource source) {
        Level dim = player.f_19853_;
        if (args.length >= 4) {
            Object dimension = "";
            for (int i = 3; i < args.length; ++i) {
                dimension = (String)dimension + args[i] + (i == args.length - 1 ? "" : " ");
            }
            dimension = DimensionMapReloadListener.toTitleCase((String)dimension);
            String key = dimension;
            if (TardimManager.DIMENSION_MAP.containsKey(dimension)) {
                key = TardimManager.DIMENSION_MAP.get(dimension);
            }
            if (!CommandTravel.isValidPath(key)) {
                CommandFuelCalculator.sendResponse(player, "Invalid dimension, defaulting to current", CommandTardimBase.ResponseType.FAIL, source);
            } else {
                ResourceKey r = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)new ResourceLocation(key));
                dim = player.m_20194_().m_129880_(r);
            }
        }
        if (args.length >= 3) {
            data = TardimManager.getFromPos(pos);
            if (data != null) {
                if (data.hasPermission(player)) {
                    try {
                        int x = Integer.parseInt(args[0]);
                        int y = Integer.parseInt(args[1]);
                        int z = Integer.parseInt(args[2]);
                        ServerLevel currentLevel = player.m_20194_().m_129880_(data.getCurrentLocation().getLevel());
                        double fuel = data.calculateFuelForJourney((Level)currentLevel, dim, data.getCurrentLocation().getPos(), new BlockPos(x, y, z));
                        fuel *= 100.0;
                        fuel = (int)fuel;
                        CommandFuelCalculator.sendResponse(player, "Estimated fuel usage: " + (fuel /= 100.0), CommandTardimBase.ResponseType.COMPLETE, source);
                    }
                    catch (Exception e) {
                        CommandFuelCalculator.sendResponse(player, "Invalid coordinates", CommandTardimBase.ResponseType.FAIL, source);
                    }
                } else {
                    CommandFuelCalculator.sendResponse(player, "You do not have permission", CommandTardimBase.ResponseType.FAIL, source);
                }
            }
        } else {
            data = TardimManager.getFromPos(pos);
            if (data != null && data.hasPermission(player)) {
                if (data.getTravelLocation() != null) {
                    ServerLevel currentLevel = player.m_20194_().m_129880_(data.getCurrentLocation().getLevel());
                    ServerLevel nextLevel = player.m_20194_().m_129880_(data.getTravelLocation().getLevel());
                    double fuel = data.calculateFuelForJourney((Level)currentLevel, (Level)nextLevel, data.getCurrentLocation().getPos(), data.getTravelLocation().getPos());
                    fuel *= 100.0;
                    fuel = (int)fuel;
                    CommandFuelCalculator.sendResponse(player, "Estimated fuel usage: " + (fuel /= 100.0), CommandTardimBase.ResponseType.COMPLETE, source);
                } else {
                    CommandFuelCalculator.sendResponse(player, "No flight information set", CommandTardimBase.ResponseType.FAIL, source);
                }
            }
        }
    }

    @Override
    public String getCommandName() {
        return "fuel-calc";
    }

    @Override
    public String getUsage() {
        return "/fuel-calc (x, y, z) (dimension)";
    }

    @Override
    public CommandTardimBase.CommandSource allowedSource() {
        return CommandTardimBase.CommandSource.BOTH;
    }
}

