/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.command.tardim;

import com.swdteam.common.command.tardim.CommandTardimBase;
import com.swdteam.tardim.TardimData;
import com.swdteam.tardim.TardimManager;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;

public class CommandLocateBiome
extends CommandTardimBase {
    @Override
    public void execute(String[] args, Player player, BlockPos pos, CommandTardimBase.CommandSource source) {
        if (args.length == 1) {
            TardimData data = TardimManager.getFromPos(pos);
            if (data != null) {
                if (data.hasPermission(player)) {
                    Optional biome = player.m_20194_().m_129911_().m_175515_(Registry.f_122885_).m_6612_(new ResourceLocation(args[0]));
                    if (biome != null && biome.isPresent()) {
                        if (data.getTravelLocation() == null) {
                            data.setTravelLocation(new TardimData.Location(data.getCurrentLocation()));
                        }
                        ServerLevel level = player.m_20194_().m_129880_(data.getTravelLocation().getLevel());
                        BlockPos blockpos = new BlockPos(data.getTravelLocation().getPos().m_123341_(), level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, data.getTravelLocation().getPos()).m_123342_(), data.getTravelLocation().getPos().m_123343_());
                        BlockPos blockpos1 = level.m_8705_((Biome)biome.get(), blockpos, 6400, 8);
                        System.out.println(level.m_46472_());
                        if (blockpos1 != null) {
                            data.getTravelLocation().setPosition(blockpos1.m_123341_(), blockpos1.m_123342_(), blockpos1.m_123343_());
                            data.save();
                            CommandLocateBiome.sendResponse(player, "Coordinates set to: " + blockpos1.m_123341_() + ", " + blockpos1.m_123342_() + ", " + blockpos1.m_123343_(), CommandTardimBase.ResponseType.COMPLETE, source);
                        } else {
                            CommandLocateBiome.sendResponse(player, "Cannot locate biome", CommandTardimBase.ResponseType.FAIL, source);
                        }
                    } else {
                        CommandLocateBiome.sendResponse(player, "Unknown biome", CommandTardimBase.ResponseType.FAIL, source);
                    }
                } else {
                    CommandLocateBiome.sendResponse(player, "You do not have permission", CommandTardimBase.ResponseType.FAIL, source);
                }
            }
        } else {
            CommandLocateBiome.sendResponse(player, this.getUsage(), CommandTardimBase.ResponseType.FAIL, source);
        }
    }

    @Override
    public String getCommandName() {
        return "locate-biome";
    }

    @Override
    public String getUsage() {
        return "/locate-biome <biome>";
    }

    @Override
    public CommandTardimBase.CommandSource allowedSource() {
        return CommandTardimBase.CommandSource.BOTH;
    }
}

