/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.command.tardim;

import com.swdteam.common.command.tardim.CommandTardimBase;
import com.swdteam.common.command.tardim.CommandTravel;
import com.swdteam.common.data.DimensionMapReloadListener;
import com.swdteam.tardim.TardimData;
import com.swdteam.tardim.TardimManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CommandSetDimension
extends CommandTardimBase {
    @Override
    public void execute(String[] args, Player player, BlockPos pos, CommandTardimBase.CommandSource source) {
        if (args.length > 0) {
            Object dimension = "";
            int i = 0;
            for (String s : args) {
                dimension = (String)dimension + s + (i == args.length - 1 ? "" : " ");
                ++i;
            }
            dimension = DimensionMapReloadListener.toTitleCase((String)dimension);
            TardimData data = TardimManager.getFromPos(pos);
            if (data != null) {
                if (data.hasPermission(player)) {
                    String key = dimension;
                    if (TardimManager.DIMENSION_MAP.containsKey(dimension)) {
                        key = TardimManager.DIMENSION_MAP.get(dimension);
                    }
                    if (!CommandTravel.isValidPath(key)) {
                        CommandSetDimension.sendResponse(player, "Invalid dimension", CommandTardimBase.ResponseType.FAIL, source);
                    } else {
                        ResourceKey r = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)new ResourceLocation(key));
                        if (player.m_20194_().m_129880_(r) != null) {
                            if (data.getTravelLocation() == null) {
                                data.setTravelLocation(new TardimData.Location(data.getCurrentLocation()));
                            }
                            data.getTravelLocation().setLocation((ResourceKey<Level>)r);
                            CommandSetDimension.sendResponse(player, "Set dimension to: " + (String)dimension, CommandTardimBase.ResponseType.COMPLETE, source);
                        } else {
                            CommandSetDimension.sendResponse(player, "Invalid dimension", CommandTardimBase.ResponseType.FAIL, source);
                        }
                    }
                } else {
                    CommandSetDimension.sendResponse(player, "You do not have permission", CommandTardimBase.ResponseType.FAIL, source);
                }
            }
        } else {
            CommandSetDimension.sendResponse(player, this.getUsage(), CommandTardimBase.ResponseType.FAIL, source);
        }
    }

    @Override
    public String getCommandName() {
        return "set-dimension";
    }

    @Override
    public String getUsage() {
        return "/set-dimension <dimension>";
    }

    @Override
    public CommandTardimBase.CommandSource allowedSource() {
        return CommandTardimBase.CommandSource.BOTH;
    }
}

