/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.command.tardim;

import com.swdteam.common.command.tardim.CommandTardimBase;
import com.swdteam.tardim.TardimData;
import com.swdteam.tardim.TardimManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;

public class CommandSetFacing
extends CommandTardimBase {
    @Override
    public void execute(String[] args, Player player, BlockPos pos, CommandTardimBase.CommandSource source) {
        if (args.length == 1) {
            TardimData data = TardimManager.getFromPos(pos);
            if (data != null) {
                if (data.hasPermission(player)) {
                    if (data.getTravelLocation() == null) {
                        data.setTravelLocation(new TardimData.Location(data.getCurrentLocation()));
                    }
                    if (data.getTravelLocation().getFacing() == null) {
                        data.getTravelLocation().setFacing(Direction.NORTH);
                    }
                    try {
                        Direction d = Direction.valueOf((String)args[0].toUpperCase());
                        data.getTravelLocation().setFacing(d);
                        data.save();
                        CommandSetFacing.sendResponse(player, "Landing direction set to: " + data.getTravelLocation().getFacing().toString(), CommandTardimBase.ResponseType.COMPLETE, source);
                    }
                    catch (Exception e) {
                        CommandSetFacing.sendResponse(player, "Invalid direction: " + args[0], CommandTardimBase.ResponseType.FAIL, source);
                    }
                } else {
                    CommandSetFacing.sendResponse(player, "You do not have permission", CommandTardimBase.ResponseType.FAIL, source);
                }
            }
        } else {
            CommandSetFacing.sendResponse(player, this.getUsage(), CommandTardimBase.ResponseType.FAIL, source);
        }
    }

    @Override
    public String getCommandName() {
        return "set-facing";
    }

    @Override
    public String getUsage() {
        return "/set-facing <direction>";
    }

    @Override
    public CommandTardimBase.CommandSource allowedSource() {
        return CommandTardimBase.CommandSource.BOTH;
    }
}

