/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.command.tardim;

import com.swdteam.common.command.tardim.CommandTardimBase;
import com.swdteam.tardim.TardimData;
import com.swdteam.tardim.TardimManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;

public class CommandSetPosition
extends CommandTardimBase {
    @Override
    public void execute(String[] args, Player player, BlockPos pos, CommandTardimBase.CommandSource source) {
        if (args.length == 3) {
            TardimData data = TardimManager.getFromPos(pos);
            if (data != null) {
                if (data.hasPermission(player)) {
                    try {
                        int x = Integer.parseInt(args[0]);
                        int y = Integer.parseInt(args[1]);
                        int z = Integer.parseInt(args[2]);
                        if (data.getTravelLocation() == null) {
                            data.setTravelLocation(new TardimData.Location(data.getCurrentLocation()));
                        }
                        data.getTravelLocation().setPosition(x, y, z);
                        data.save();
                        CommandSetPosition.sendResponse(player, "Coordinates set to: " + x + ", " + y + ", " + z, CommandTardimBase.ResponseType.COMPLETE, source);
                    }
                    catch (Exception e) {
                        CommandSetPosition.sendResponse(player, "Invalid coordinates", CommandTardimBase.ResponseType.FAIL, source);
                    }
                } else {
                    CommandSetPosition.sendResponse(player, "You do not have permission", CommandTardimBase.ResponseType.FAIL, source);
                }
            }
        } else {
            CommandSetPosition.sendResponse(player, this.getUsage(), CommandTardimBase.ResponseType.FAIL, source);
        }
    }

    @Override
    public String getCommandName() {
        return "set-coords";
    }

    @Override
    public String getUsage() {
        return "/set-coords <x> <y> <z>";
    }

    @Override
    public CommandTardimBase.CommandSource allowedSource() {
        return CommandTardimBase.CommandSource.BOTH;
    }
}

